/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@Accessors(value={AccessorType.PUBLIC_GETTER})
public class RenameContext {
    private final List<? extends RenameChange> changes;
    private final ResourceSet resourceSet;
    private final IChangeSerializer changeSerializer;
    private final RefactoringIssueAcceptor issues;

    public void addModification(RenameChange change, IChangeSerializer.IModification<EObject> modification) {
        EObject target = this.resourceSet.getEObject(change.getTargetURI(), true);
        if (target instanceof EObject) {
            EcoreUtil.resolveAll((Resource)target.eResource());
            this.changeSerializer.addModification(target, modification);
        } else {
            this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, "Element cannot be found", change.getTargetURI());
        }
    }

    public RenameContext(List<? extends RenameChange> changes, ResourceSet resourceSet, IChangeSerializer changeSerializer, RefactoringIssueAcceptor issues) {
        this.changes = changes;
        this.resourceSet = resourceSet;
        this.changeSerializer = changeSerializer;
        this.issues = issues;
    }

    @Pure
    public List<? extends RenameChange> getChanges() {
        return this.changes;
    }

    @Pure
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Pure
    public IChangeSerializer getChangeSerializer() {
        return this.changeSerializer;
    }

    @Pure
    public RefactoringIssueAcceptor getIssues() {
        return this.issues;
    }
}

