/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitReceiver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ResolvedImplicitReceiver
extends ImplicitReceiver {
    public ResolvedImplicitReceiver(XAbstractFeatureCall featureCall, XAbstractFeatureCall implicitReceiver, ExpressionTypeComputationState state) {
        super(featureCall, implicitReceiver, state);
    }

    @Override
    public void applyToComputationState() {
        ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
        LightweightTypeReference actualType = resolvedTypes.getActualType(this.getFeature());
        if (actualType == null) {
            throw new IllegalStateException("Cannot determine actual type of already resolved implicit receiver");
        }
        LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getOwner().getFeature(), actualType);
        if (expectedReceiverType != null) {
            expectedReceiverType = expectedReceiverType.copyInto(resolvedTypes.getReferenceOwner());
        }
        TypeExpectation expectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
        resolvedTypes.acceptType(this.getFeatureCall(), expectation, actualType.copyInto(resolvedTypes.getReferenceOwner()), false, 0x400000);
        super.applyToComputationState();
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
    }
}

