/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.common.base.Objects;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.RuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.SubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.WebProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.XtextProjectConfig;

public class StandardProjectConfig
extends XtextProjectConfig {
    private boolean mavenLayout;
    private boolean createEclipseMetaData;
    private String rootPath;
    private String baseName;

    @Mandatory
    public String setBaseName(String baseName) {
        this.baseName = baseName;
        return this.baseName;
    }

    @Mandatory
    public String setRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this.rootPath;
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.rootPath == null) {
            issues.addError("The property 'rootPath' must be set", this);
        }
        if (this.baseName == null) {
            issues.addError("The property 'baseName' must be set", this);
        }
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        for (SubProjectConfig subProjectConfig : this.getEnabledProjects()) {
            WebProjectConfig webProjectConfig;
            RuntimeProjectConfig runtimeProjectConfig;
            if (subProjectConfig.getName() == null) {
                subProjectConfig.setName(this.computeName(subProjectConfig));
            }
            if (subProjectConfig.getRootPath() == null) {
                subProjectConfig.setRoot(this.computeRoot(subProjectConfig));
            }
            if (subProjectConfig.getMetaInfPath() == null) {
                subProjectConfig.setMetaInf(this.computeMetaInf(subProjectConfig));
            }
            if (subProjectConfig.getSrcPath() == null) {
                subProjectConfig.setSrc(this.computeSrc(subProjectConfig));
            }
            if (subProjectConfig.getSrcGenPath() == null) {
                subProjectConfig.setSrcGen(this.computeSrcGen(subProjectConfig));
            }
            if (subProjectConfig.getIconsPath() == null) {
                subProjectConfig.setIcons(this.computeIcons(subProjectConfig));
            }
            if (subProjectConfig instanceof BundleProjectConfig && this.createEclipseMetaData) {
                BundleProjectConfig bundleProjectConfig = (BundleProjectConfig)subProjectConfig;
                if (bundleProjectConfig.getManifest() == null) {
                    bundleProjectConfig.setManifest(this.newManifestAccess());
                }
                if (bundleProjectConfig.getPluginXml() == null) {
                    bundleProjectConfig.setPluginXml(this.newPluginXmlAccess());
                }
            }
            if (subProjectConfig instanceof RuntimeProjectConfig && (runtimeProjectConfig = (RuntimeProjectConfig)subProjectConfig).getEcoreModelPath() == null) {
                runtimeProjectConfig.setEcoreModel(this.computeEcoreModel(runtimeProjectConfig));
            }
            if (!(subProjectConfig instanceof WebProjectConfig) || (webProjectConfig = (WebProjectConfig)subProjectConfig).getAssetsPath() != null) continue;
            webProjectConfig.setAssets(this.computeAssets(webProjectConfig));
        }
    }

    protected String computeName(SubProjectConfig project) {
        if (Objects.equal((Object)project, (Object)this.getRuntime())) {
            return this.baseName;
        }
        if (Objects.equal((Object)project, (Object)this.getRuntimeTest())) {
            if (!this.mavenLayout) {
                return this.baseName + ".tests";
            }
            return this.baseName;
        }
        if (Objects.equal((Object)project, (Object)this.getGenericIde())) {
            return this.baseName + ".ide";
        }
        if (Objects.equal((Object)project, (Object)this.getEclipsePlugin())) {
            return this.baseName + ".ui";
        }
        if (Objects.equal((Object)project, (Object)this.getEclipsePluginTest())) {
            if (!this.mavenLayout) {
                return this.baseName + ".ui.tests";
            }
            return this.baseName + ".ui";
        }
        if (Objects.equal((Object)project, (Object)this.getWeb())) {
            return this.baseName + ".web";
        }
        return null;
    }

    protected String computeRoot(SubProjectConfig project) {
        return this.rootPath + "/" + project.getName();
    }

    protected String computeSrc(SubProjectConfig project) {
        if (this.mavenLayout) {
            return project.getRootPath() + "/src/" + this.computeSourceSet(project) + "/java";
        }
        return project.getRootPath() + "/src";
    }

    protected String computeSrcGen(SubProjectConfig project) {
        if (this.mavenLayout) {
            return project.getRootPath() + "/src/" + this.computeSourceSet(project) + "/xtext-gen";
        }
        return project.getRootPath() + "/src-gen";
    }

    protected String computeMetaInf(SubProjectConfig project) {
        if (this.mavenLayout) {
            return project.getRootPath() + "/src/" + this.computeSourceSet(project) + "/resources/META-INF";
        }
        return project.getRootPath() + "/META-INF";
    }

    protected String computeEcoreModel(RuntimeProjectConfig project) {
        return project.getRootPath() + "/model/generated";
    }

    protected String computeAssets(WebProjectConfig project) {
        if (this.mavenLayout) {
            return project.getRootPath() + "/src/" + this.computeSourceSet(project) + "/webapp";
        }
        return project.getRootPath() + "/WebRoot";
    }

    protected String computeSourceSet(SubProjectConfig project) {
        if (this.getTestProjects().contains(project)) {
            return "test";
        }
        return "main";
    }

    protected String computeIcons(SubProjectConfig project) {
        return project.getRootPath() + "/icons";
    }

    public boolean isMavenLayout() {
        return this.mavenLayout;
    }

    public void setMavenLayout(boolean mavenLayout) {
        this.mavenLayout = mavenLayout;
    }

    public boolean isCreateEclipseMetaData() {
        return this.createEclipseMetaData;
    }

    public void setCreateEclipseMetaData(boolean createEclipseMetaData) {
        this.createEclipseMetaData = createEclipseMetaData;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

