/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.quickfix;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolution;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolutionAcceptor;
import org.eclipse.xtext.ide.editor.quickfix.IQuickFixProvider;
import org.eclipse.xtext.ide.editor.quickfix.QuickFix;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;

@Beta
public class AbstractDeclarativeIdeQuickfixProvider
implements IQuickFixProvider {
    private static final Logger LOG = Logger.getLogger(AbstractDeclarativeIdeQuickfixProvider.class);
    private Map<String, List<Method>> methods = new ConcurrentHashMap<String, List<Method>>();
    @Inject
    private Provider<DiagnosticResolutionAcceptor> issueResolutionAcceptorProvider;

    private boolean getFixMethodPredicate(Method input, String issueCode) {
        for (QuickFix annotation : (QuickFix[])input.getAnnotationsByType(QuickFix.class)) {
            boolean result;
            boolean bl = result = annotation != null && Objects.equals(issueCode, annotation.value()) && input.getParameterTypes().length == 1 && Void.TYPE == input.getReturnType() && input.getParameterTypes()[0].isAssignableFrom(DiagnosticResolutionAcceptor.class);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DiagnosticResolution> getResolutions(ICodeActionService2.Options options, Diagnostic diagnostic) {
        DiagnosticResolutionAcceptor issueResolutionAcceptor = (DiagnosticResolutionAcceptor)this.issueResolutionAcceptorProvider.get();
        for (Method fixMethod : this.getFixMethods(diagnostic)) {
            try {
                fixMethod.invoke((Object)this, issueResolutionAcceptor);
            }
            catch (Exception e) {
                LOG.error((Object)"Error executing fix method", (Throwable)e);
            }
        }
        return issueResolutionAcceptor.getDiagnosticResolutions(options, diagnostic);
    }

    private List<Method> collectMethods(Class<? extends AbstractDeclarativeIdeQuickfixProvider> clazz, String issueCode) {
        return Arrays.stream(clazz.getMethods()).filter(method -> this.getFixMethodPredicate((Method)method, issueCode)).collect(Collectors.toList());
    }

    @Override
    public boolean handlesDiagnostic(Diagnostic diagnostic) {
        return !this.getFixMethods(diagnostic).isEmpty();
    }

    public List<Method> getFixMethods(Diagnostic diagnostic) {
        if (diagnostic == null || diagnostic.getCode() == null || diagnostic.getMessage() == null || diagnostic.getSeverity() == null) {
            return Collections.emptyList();
        }
        String issueCode = (String)diagnostic.getCode().getLeft();
        if (Strings.isNullOrEmpty((String)issueCode)) {
            return Collections.emptyList();
        }
        return this.methods.computeIfAbsent(issueCode, c -> this.collectMethods((Class<? extends AbstractDeclarativeIdeQuickfixProvider>)this.getClass(), (String)c));
    }

    protected List<TextEdit> createTextEdit(Diagnostic diagnostic, String text) {
        return Collections.singletonList(new TextEdit(diagnostic.getRange(), text));
    }
}

