/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.syntaxcoloring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.LightweightPosition;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class MergingHighlightedPositionAcceptor
implements IHighlightedPositionAcceptor,
ISemanticHighlightingCalculator {
    private final ISemanticHighlightingCalculator delegate;
    private final List<LightweightPosition> positions;
    private int timestamp;
    private int expectedOffset;
    private boolean requireMerge;

    public MergingHighlightedPositionAcceptor(ISemanticHighlightingCalculator delegate) {
        this.delegate = delegate;
        this.positions = new ArrayList<LightweightPosition>(50);
        this.initialize();
    }

    @Override
    public void addPosition(int offset, int length, String ... ids) {
        if (length > 0) {
            this.getPositions().add(this.newPosition(offset, length, this.timestamp, ids));
            if (offset < this.expectedOffset) {
                this.requireMerge = true;
            }
            this.expectedOffset = offset + length;
        }
        ++this.timestamp;
    }

    protected LightweightPosition newPosition(int offset, int length, int timestamp, String ... ids) {
        return new LightweightPosition(offset, length, timestamp, ids);
    }

    protected LightweightPosition newPosition(int offset, int length, int timestamp, LightweightPosition.IntToStringArray[] ids) {
        return new LightweightPosition(offset, length, timestamp, ids);
    }

    @Override
    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        this.initialize();
        this.delegate.provideHighlightingFor(resource, this, cancelIndicator);
        this.mergePositions();
        for (LightweightPosition pos : this.getPositions()) {
            acceptor.addPosition(pos.getOffset(), pos.getLength(), pos.getIds());
        }
    }

    private void initialize() {
        if (!this.getPositions().isEmpty()) {
            this.getPositions().clear();
        }
        this.timestamp = 0;
        this.expectedOffset = 0;
        this.requireMerge = false;
    }

    public void mergePositions() {
        if (this.getPositions().size() < 2 || !this.requireMerge) {
            return;
        }
        Collections.sort(this.getPositions());
        LightweightPosition prev = this.getPositions().get(0);
        int i = 1;
        while (i < this.getPositions().size()) {
            LightweightPosition next = this.getPositions().get(i);
            int exclusiveEndOffset = prev.getOffset() + prev.getLength();
            if (next.getOffset() < exclusiveEndOffset) {
                int newLength = next.getOffset() - prev.getOffset();
                prev.setLength(newLength);
                this.mergePositions(i, exclusiveEndOffset, prev.getTimestamp(), prev.internalGetIds());
                if (prev.getLength() == 0 && prev != this.getPositions().remove(i - 1)) {
                    throw new IllegalStateException("removed position is not 'prev'");
                }
            }
            if (prev.getLength() != 0) {
                ++i;
            }
            prev = this.getPositions().get(i - 1);
        }
    }

    private void mergePositions(int listIdx, int exclusiveEndOffset, int timestamp, LightweightPosition.IntToStringArray[] ids) {
        int i;
        ArrayList newPositions = null;
        LightweightPosition prev = null;
        for (i = listIdx; i < this.getPositions().size(); ++i) {
            int prevEnd;
            LightweightPosition next = this.getPositions().get(i);
            if (next.getOffset() >= exclusiveEndOffset) {
                newPositions = this.addPendingPosition(prev, exclusiveEndOffset, timestamp, ids, newPositions);
                this.partialSortPositions(listIdx, exclusiveEndOffset, i, newPositions);
                return;
            }
            if (prev != null && (prevEnd = prev.getOffset() + prev.getLength()) < next.getOffset()) {
                if (newPositions == null) {
                    newPositions = Lists.newArrayListWithExpectedSize((int)4);
                }
                newPositions.add(this.newPosition(prevEnd, next.getOffset() - prevEnd, timestamp, ids));
            }
            if (next.getOffset() + next.getLength() <= exclusiveEndOffset) {
                next.merge(ids);
            } else {
                int oldLength = next.getLength();
                next.setLength(exclusiveEndOffset - next.getOffset());
                if (newPositions == null) {
                    newPositions = Lists.newArrayListWithExpectedSize((int)4);
                }
                newPositions.add(this.newPosition(next.getOffset() + next.getLength(), oldLength - next.getLength(), next.getTimestamp(), next.getIds()));
                next.merge(ids);
            }
            prev = next;
        }
        newPositions = this.addPendingPosition(prev, exclusiveEndOffset, timestamp, ids, newPositions);
        this.partialSortPositions(listIdx, exclusiveEndOffset, i, newPositions);
    }

    private void partialSortPositions(int listIdx, int exclusiveEndOffset, int insertionIndex, List<LightweightPosition> addedPositions) {
        int newPosSize;
        int n = newPosSize = addedPositions != null ? addedPositions.size() : 0;
        if (newPosSize != 0) {
            this.getPositions().addAll(insertionIndex, addedPositions);
        }
        if (insertionIndex + newPosSize != listIdx) {
            int endIdx;
            for (endIdx = insertionIndex + newPosSize; endIdx < this.getPositions().size() && this.getPositions().get(endIdx).getOffset() == exclusiveEndOffset; ++endIdx) {
            }
            Collections.sort(this.getPositions().subList(listIdx, endIdx));
        }
    }

    private List<LightweightPosition> addPendingPosition(LightweightPosition pending, int expectedEndOffset, int timestamp, LightweightPosition.IntToStringArray[] ids, List<LightweightPosition> result) {
        int prevEnd;
        if (pending != null && (prevEnd = pending.getOffset() + pending.getLength()) < expectedEndOffset) {
            LightweightPosition position = this.newPosition(prevEnd, expectedEndOffset - prevEnd, timestamp, ids);
            if (result == null) {
                result = Collections.singletonList(position);
            } else {
                result.add(position);
            }
        }
        return result;
    }

    public List<LightweightPosition> getPositions() {
        return this.positions;
    }
}

