/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.MultiOrganizeImportAction;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.xbase.ui.imports.Messages;
import org.eclipse.xtext.xbase.ui.imports.MultiImportOrganizer;

@Singleton
public class MultiOrganizeImportsHandler
extends AbstractHandler {
    @Inject
    private FileExtensionProvider fileExtensions;
    @Inject
    private Provider<MultiImportOrganizer> importOrganizerProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchSite activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        MultiOrganizeImportAction javaDelegate = new MultiOrganizeImportAction(activeSite);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            ICompilationUnit[] compilationUnits;
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            if (this.shouldRunJavaOrganizeImports() && (compilationUnits = javaDelegate.getCompilationUnits(structuredSelection)).length > 0) {
                javaDelegate.run(structuredSelection);
            }
            final Multimap<IProject, IFile> files = this.collectFiles(structuredSelection);
            Shell shell = activeSite.getShell();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
                    mon.beginTask(Messages.OrganizeImports, files.size() * 2);
                    mon.setTaskName(String.valueOf(Messages.OrganizeImports) + " - Calculating Import optimisations for " + files.size() + " Xtend files");
                    List<Change> organizeImports = ((MultiImportOrganizer)MultiOrganizeImportsHandler.this.importOrganizerProvider.get()).organizeImports((Multimap<IProject, IFile>)files, mon);
                    int i = 0;
                    while (!mon.isCanceled() && i < organizeImports.size()) {
                        Change change = organizeImports.get(i);
                        mon.setTaskName("Performing changes - Xtend " + (i + 1) + " of " + files.size());
                        try {
                            mon.subTask(change.getName());
                            change.perform((IProgressMonitor)SubMonitor.convert((IProgressMonitor)mon, (int)1));
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        if (mon.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ++i;
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                this.handleException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return event.getApplicationContext();
    }

    private void handleException(Exception e) throws ExecutionException {
        throw new ExecutionException(Messages.MultiOrganizeImportsHandler_exceptionMessage, (Throwable)e);
    }

    protected boolean shouldHandleFile(IFile object) {
        String fileExtension = object.getFileExtension();
        return fileExtension != null && this.fileExtensions.getFileExtensions().contains(fileExtension);
    }

    protected boolean shouldRunJavaOrganizeImports() {
        return true;
    }

    private Multimap<IProject, IFile> collectFiles(IStructuredSelection structuredSelection) {
        HashMultimap result = HashMultimap.create();
        for (Object object : structuredSelection.toList()) {
            this.collectRelevantFiles(object, (Multimap<IProject, IFile>)result);
        }
        return result;
    }

    private void collectRelevantFiles(Object element, Multimap<IProject, IFile> result) {
        try {
            if (element instanceof IJavaElement) {
                IJavaElement elem = (IJavaElement)element;
                if (elem.exists()) {
                    switch (elem.getElementType()) {
                        case 4: {
                            this.collectRelevantFiles((IPackageFragment)elem, result);
                            break;
                        }
                        case 3: {
                            this.collectRelevantFiles((IPackageFragmentRoot)elem, result);
                            break;
                        }
                        case 2: {
                            IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                            int k = 0;
                            while (k < roots.length) {
                                this.collectRelevantFiles(roots[k], result);
                                ++k;
                            }
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (element instanceof LogicalPackage) {
                IPackageFragment[] packageFragments = ((LogicalPackage)element).getFragments();
                int k = 0;
                while (k < packageFragments.length) {
                    IPackageFragment pack = packageFragments[k];
                    if (pack.exists()) {
                        this.collectRelevantFiles(pack, result);
                    }
                    ++k;
                }
            } else if (element instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)element;
                IAdaptable[] elements = workingSet.getElements();
                int j = 0;
                while (j < elements.length) {
                    this.collectRelevantFiles(elements[j], result);
                    ++j;
                }
            } else if (element instanceof IFile) {
                this.collectIFiles(result, new Object[]{element});
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void collectRelevantFiles(IPackageFragment element, Multimap<IProject, IFile> result) throws JavaModelException {
        if (!element.isDefaultPackage()) {
            this.collectIFiles(result, element.getNonJavaResources());
        } else if (element.getResource() instanceof IFolder) {
            IFolder folder = (IFolder)element.getResource();
            try {
                this.collectIFiles(result, folder.members());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void collectRelevantFiles(IPackageFragmentRoot root, Multimap<IProject, IFile> result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectRelevantFiles((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private void collectIFiles(Multimap<IProject, IFile> result, Object[] nonJavaResources) {
        Object[] objectArray = nonJavaResources;
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile;
            Object object = objectArray[n2];
            if (object instanceof IFile && this.shouldHandleFile(iFile = (IFile)object)) {
                result.put((Object)iFile.getProject(), (Object)iFile);
            }
            ++n2;
        }
    }
}

