/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import java.util.List;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.impl.XClosureImplCustom;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IClosureCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;

public abstract class AbstractClosureTypeHelper
implements IClosureCandidate {
    private final XClosure closure;
    private final ITypeComputationState state;
    private final CommonTypeComputationServices services;
    private final ITypeExpectation expectation;

    protected AbstractClosureTypeHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        this.closure = closure;
        this.expectation = expectation;
        this.state = state;
        this.services = state.getReferenceOwner().getServices();
    }

    protected ITypeComputationState getState() {
        return this.state;
    }

    protected ITypeExpectation getExpectation() {
        return this.expectation;
    }

    protected XClosure getClosure() {
        return this.closure;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected abstract void computeTypes();

    public abstract FunctionTypeReference getExpectedClosureType();

    public abstract JvmOperation getOperation();

    protected void deferredBindTypeArgument(LightweightTypeReference declared, LightweightTypeReference actual, final BoundTypeArgumentSource source) {
        if (declared != null) {
            ExpectationTypeParameterHintCollector collector = new ExpectationTypeParameterHintCollector(this.expectation.getReferenceOwner()){

                @Override
                protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                    LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                    if (source == BoundTypeArgumentSource.INFERRED_CONSTRAINT) {
                        wrapped = this.getStricterConstraint(typeParameter, wrapped);
                    }
                    typeParameter.acceptHint(wrapped, source, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                }

                @Override
                protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
                    return new UnboundParameterizedTypeReferencePreserver();
                }

                @Override
                protected AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
                    return new UnboundArrayTypeReferencePreserver();
                }

                class UnboundArrayTypeReferencePreserver
                extends ExpectationTypeParameterHintCollector.DeferredArrayTypeReferenceTraverser {
                    UnboundArrayTypeReferencePreserver() {
                        super(this);
                    }

                    @Override
                    public void doVisitUnboundTypeReference(UnboundTypeReference reference, ArrayTypeReference declaration) {
                        if (reference.internalIsResolved() || this.getOwner().isResolved(reference.getHandle())) {
                            reference.tryResolve();
                            this.outerVisit(reference, declaration);
                        } else {
                            this.addHint(reference, declaration);
                        }
                    }
                }

                class UnboundParameterizedTypeReferencePreserver
                extends ExpectationTypeParameterHintCollector.DeferredParameterizedTypeReferenceTraverser {
                    UnboundParameterizedTypeReferencePreserver() {
                        super(this);
                    }

                    @Override
                    public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
                        if (reference.internalIsResolved() || this.getOwner().isResolved(reference.getHandle())) {
                            reference.tryResolve();
                            this.outerVisit(reference, declaration);
                        } else {
                            this.addHint(reference, declaration);
                        }
                    }
                }
            };
            collector.processPairedReferences(declared, actual);
        }
    }

    @Override
    public void applyToModel(IResolvedTypes resolvedTypes) {
        if (!this.closure.isExplicitSyntax()) {
            List<JvmFormalParameter> parametersToAdd = this.getParameters();
            InternalEList targetList = (InternalEList)this.closure.getImplicitFormalParameters();
            if (!targetList.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < parametersToAdd.size()) {
                JvmFormalParameter parameter = parametersToAdd.get(i);
                LightweightTypeReference parameterType = resolvedTypes.getActualType((JvmIdentifiableElement)parameter);
                if (parameterType == null) {
                    throw new IllegalStateException("Cannot find type for parameter " + parameter.getSimpleName());
                }
                JvmTypeReference typeReference = parameterType.toTypeReference();
                parameter.setParameterType(typeReference);
                targetList.addUnique((Object)parameter);
                ++i;
            }
        }
        ((XClosureImplCustom)this.closure).setLinked(true);
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        return true;
    }

    @Override
    public abstract List<JvmFormalParameter> getParameters();
}

