/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.SemanticModificationWrapper;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.validation.Issue;

public class IssueResolutionAcceptor {
    private List<IssueResolution> issueResolutions = Lists.newArrayList();
    private IssueModificationContext.Factory modificationContextFactory;

    @Inject
    public IssueResolutionAcceptor(IssueModificationContext.Factory modificationContextFactory) {
        this.modificationContextFactory = modificationContextFactory;
    }

    public void accept(Issue issue, String label, String description, String image, IModification modification) {
        this.issueResolutions.add(new IssueResolution(label, description, image, this.modificationContextFactory.createModificationContext(issue), modification));
    }

    public void accept(Issue issue, String label, String description, String image, ISemanticModification semanticModification) {
        SemanticModificationWrapper modificationWrapper = new SemanticModificationWrapper(issue.getUriToProblem(), semanticModification);
        this.issueResolutions.add(new IssueResolution(label, description, image, this.modificationContextFactory.createModificationContext(issue), modificationWrapper));
    }

    public void accept(Issue issue, String label, String description, String image, IModification modification, int relevance) {
        this.issueResolutions.add(new IssueResolution(label, description, image, this.modificationContextFactory.createModificationContext(issue), modification, relevance));
    }

    public void accept(Issue issue, String label, String description, String image, ISemanticModification semanticModification, int relevance) {
        SemanticModificationWrapper modificationWrapper = new SemanticModificationWrapper(issue.getUriToProblem(), semanticModification);
        this.issueResolutions.add(new IssueResolution(label, description, image, this.modificationContextFactory.createModificationContext(issue), modificationWrapper, relevance));
    }

    public List<IssueResolution> getIssueResolutions() {
        return this.issueResolutions;
    }
}

