/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.mtj.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.preverifier.internal.PreverificationClassNode;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.eclipse.mtj.preverifier.results.PreverificationResults;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassPreverifier {
    private static final int INVALID_FLAG = -1;
    private IPreverificationPolicy preverificationPolicy;

    public ClassPreverifier(IPreverificationPolicy iPreverificationPolicy) {
        this.preverificationPolicy = iPreverificationPolicy;
    }

    public PreverificationResults preverify(InputStream inputStream, URL[] uRLArray) throws IOException {
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        return this.preverify(inputStream, uRLClassLoader);
    }

    public PreverificationResults preverify(InputStream inputStream, ClassLoader classLoader) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Class byte stream must not be null");
        }
        PreverificationClassNode preverificationClassNode = new PreverificationClassNode(this.preverificationPolicy, classLoader);
        ClassReader classReader = new ClassReader(inputStream);
        classReader.accept((ClassVisitor)preverificationClassNode, 0);
        inputStream.close();
        List list = preverificationClassNode.getErrorList();
        PreverificationError[] preverificationErrorArray = list.toArray(new PreverificationError[list.size()]);
        PreverificationResults preverificationResults = null;
        if (preverificationErrorArray.length > 0) {
            preverificationResults = new PreverificationResults(null, null, preverificationErrorArray);
        } else {
            ClassWriter classWriter = new ClassWriter(-1);
            preverificationClassNode.accept((ClassVisitor)classWriter);
            byte[] byArray = classWriter.toByteArray();
            preverificationResults = new PreverificationResults(preverificationClassNode, byArray, preverificationErrorArray);
        }
        return preverificationResults;
    }
}

