/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mtj.preverifier.internal.MethodRewriter;
import org.eclipse.mtj.preverifier.internal.PreverificationClassNode;
import org.eclipse.mtj.preverifier.internal.results.ClassNodeErrorInformation;
import org.eclipse.mtj.preverifier.internal.results.FieldErrorInformation;
import org.eclipse.mtj.preverifier.internal.results.MethodNodeErrorInformation;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.eclipse.mtj.preverifier.results.PreverificationErrorLocation;
import org.eclipse.mtj.preverifier.results.PreverificationErrorLocationType;
import org.eclipse.mtj.preverifier.results.PreverificationErrorType;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class PreverifierMethodNode
extends MethodNode {
    private PreverificationClassNode classNode;
    private int lineNumber;
    private List jsrInstructionIndices;
    private Map labelIndices;

    public PreverifierMethodNode(PreverificationClassNode preverificationClassNode, int n, String string, String string2, String string3, String[] stringArray) {
        super(n, string, string2, string3, stringArray);
        this.classNode = preverificationClassNode;
        this.lineNumber = -1;
        this.jsrInstructionIndices = new ArrayList();
        this.labelIndices = new HashMap();
    }

    List getJsrInstructionIndices() {
        return this.jsrInstructionIndices;
    }

    Map getLabelIndices() {
        return this.labelIndices;
    }

    public void visitEnd() {
        boolean bl;
        boolean bl2 = bl = (this.access & 0x100) != 0 || (this.access & 0x400) != 0;
        if (bl) {
            this.classNode.methods.add(this);
        } else {
            MethodRewriter methodRewriter = new MethodRewriter(this.classNode, this);
            try {
                MethodNode methodNode = methodRewriter.getUpdatedMethod();
                this.classNode.methods.add(methodNode);
            }
            catch (AnalyzerException analyzerException) {
                throw new RuntimeException("Method " + this.name + ": " + analyzerException.getMessage(), analyzerException);
            }
        }
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        if (this.isDisallowedInstruction(n)) {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, this);
            FieldErrorInformation fieldErrorInformation = new FieldErrorInformation(string2, string3);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_FIELD, classNodeErrorInformation, methodNodeErrorInformation, fieldErrorInformation, this.lineNumber);
            PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.FLOATING_POINT, preverificationErrorLocation, null);
            this.addError(preverificationError);
        }
        super.visitFieldInsn(n, string, string2, string3);
    }

    public void visitIincInsn(int n, int n2) {
        super.visitIincInsn(n, n2);
    }

    public void visitInsn(int n) {
        if (this.isDisallowedInstruction(n)) {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, this);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, classNodeErrorInformation, methodNodeErrorInformation, null, this.lineNumber);
            PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.FLOATING_POINT, preverificationErrorLocation, null);
            this.addError(preverificationError);
        }
        super.visitInsn(n);
    }

    public void visitIntInsn(int n, int n2) {
        if (n == 188 && (n2 == 7 || n2 == 6)) {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, this);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, classNodeErrorInformation, methodNodeErrorInformation, null, this.lineNumber);
            PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.FLOATING_POINT, preverificationErrorLocation, null);
            this.addError(preverificationError);
        }
        super.visitIntInsn(n, n2);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        if (this.isDisallowedType(string2)) {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, this);
            FieldErrorInformation fieldErrorInformation = new FieldErrorInformation(string, string2);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_FIELD, classNodeErrorInformation, methodNodeErrorInformation, fieldErrorInformation, this.lineNumber);
            PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.FLOATING_POINT, preverificationErrorLocation, null);
            this.addError(preverificationError);
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        if (this.isDisallowedType(string)) {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, this);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, classNodeErrorInformation, methodNodeErrorInformation, null, this.lineNumber);
            PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.FLOATING_POINT, preverificationErrorLocation, null);
            this.addError(preverificationError);
        }
        super.visitMultiANewArrayInsn(string, n);
    }

    public void visitVarInsn(int n, int n2) {
        super.visitVarInsn(n, n2);
    }

    public void visitJumpInsn(int n, Label label) {
        if (this.isDisallowedInstruction(n)) {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, this);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, classNodeErrorInformation, methodNodeErrorInformation, null, this.lineNumber);
            PreverificationError preverificationError = new PreverificationError(PreverificationErrorType.FLOATING_POINT, preverificationErrorLocation, null);
            this.addError(preverificationError);
        } else if (n == 168) {
            this.jsrInstructionIndices.add(new Integer(this.instructions.size()));
        }
        super.visitJumpInsn(n, label);
    }

    public void visitLabel(Label label) {
        this.labelIndices.put(label, new Integer(this.instructions.size()));
        super.visitLabel(label);
    }

    public void visitLineNumber(int n, Label label) {
        this.lineNumber = n;
        super.visitLineNumber(n, label);
    }

    private void addError(PreverificationError preverificationError) {
        this.classNode.getErrorList().add(preverificationError);
    }

    private boolean isDisallowedInstruction(int n) {
        return !this.classNode.getPreverificationPolicy().isFloatingPointAllowed() && this.isFloatingPointOpcode(n);
    }

    private boolean isDisallowedType(String string) {
        Type type = Type.getType((String)string);
        PreverificationErrorType preverificationErrorType = this.classNode.validateType(type);
        return preverificationErrorType != PreverificationErrorType.NO_ERROR;
    }

    private boolean isFloatingPointOpcode(int n) {
        boolean bl = false;
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 134: 
            case 135: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 174: 
            case 175: {
                bl = true;
            }
        }
        return bl;
    }
}

