/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier.internal;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

public class SimpleVerifierPlusClassloader
extends SimpleVerifier {
    private ClassLoader classLoader;

    public SimpleVerifierPlusClassloader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Class getClass(Type type) {
        Class<?> clazz = null;
        if (this.classLoader == null) {
            clazz = super.getClass(type);
        } else {
            try {
                String string = this.getRootClassName(type);
                clazz = this.classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                throw new RuntimeException(classNotFoundException.toString());
            }
        }
        return clazz;
    }

    protected String getRootClassName(Type type) {
        String string = null;
        switch (type.getSort()) {
            case 1: {
                string = "java.lang.Boolean";
                break;
            }
            case 2: {
                string = "java.lang.Character";
                break;
            }
            case 3: {
                string = "java.lang.Byte";
                break;
            }
            case 4: {
                string = "java.lang.Short";
                break;
            }
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case 6: {
                string = "java.lang.Float";
                break;
            }
            case 7: {
                string = "java.lang.Long";
                break;
            }
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case 9: {
                string = this.getRootClassName(type.getElementType());
                break;
            }
            case 10: {
                string = type.getInternalName().replace('/', '.');
            }
        }
        return string;
    }
}

