/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier.results;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;

public class PreverificationResults {
    private ClassNode preverifiedClassNode;
    private byte[] preverifiedClassBytes;
    private PreverificationError[] errors;

    public PreverificationResults(ClassNode classNode, byte[] byArray, PreverificationError[] preverificationErrorArray) {
        this.preverifiedClassNode = classNode;
        this.preverifiedClassBytes = byArray;
        this.errors = preverificationErrorArray;
    }

    public PreverificationError[] getErrors() {
        return this.errors;
    }

    public byte[] getPreverifiedClassBytes() {
        return this.preverifiedClassBytes;
    }

    public ClassNode getPreverifiedClassNode() {
        return this.preverifiedClassNode;
    }

    public String getDisassembledOutput() {
        String string = null;
        if (this.errors.length == 0) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(printWriter);
            this.preverifiedClassNode.accept((ClassVisitor)traceClassVisitor);
            printWriter.close();
            string = stringWriter.toString();
        }
        return string;
    }

    public boolean isErrorResult() {
        return this.errors.length > 0;
    }
}

