/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preverification.builder;

import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.BuildLoggingConfiguration;
import org.eclipse.mtj.core.console.BuildConsoleProxy;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.PreferenceAccessor;
import org.eclipse.mtj.core.internal.packaging.DeployedJADWriter;
import org.eclipse.mtj.core.internal.packaging.ObfuscatorTool;
import org.eclipse.mtj.core.internal.preverification.builder.BuildInfo;
import org.eclipse.mtj.core.internal.preverification.builder.ResourceDeltaBuilder;
import org.eclipse.mtj.core.internal.preverifier.PreverificationUtils;
import org.eclipse.mtj.core.internal.utils.AbstractClasspathEntryVisitor;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.preverifier.results.PreverificationError;

public class PreverificationBuilder
extends IncrementalProjectBuilder {
    public static final String ARG_UPDATE_VERSION = "_update_version";
    public static final String ARG_DO_PACKAGE = "_do_package";
    public static final String ARG_DO_OBFUSCATION = "_do_obfuscation";
    private static BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.instance;
    private static Map<IProject, de.schlichtherle.io.File> runtimeJars = new HashMap<IProject, de.schlichtherle.io.File>(5);

    public static void cleanProject(IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        IFolder iFolder;
        IFolder iFolder2;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.cleanProject project = " + iProject);
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        BuildInfo buildInfo = new BuildInfo(15, new HashMap(), iJavaProject);
        IFolder iFolder3 = iProject.getFolder(MTJCorePlugin.getVerifiedOutputDirectoryName());
        if (iFolder3.exists()) {
            Utils.clearContainer((IContainer)iFolder3, iProgressMonitor);
            iFolder3.delete(true, iProgressMonitor);
        }
        if ((iFolder2 = iProject.getFolder(".mtj.tmp").getFolder("runtime")).exists()) {
            Utils.clearContainer((IContainer)iFolder2, iProgressMonitor);
            iFolder2.delete(true, iProgressMonitor);
        }
        IFolder iFolder4 = buildInfo.getVerifiedClassesFolder(iProgressMonitor);
        Utils.clearContainer((IContainer)iFolder4, iProgressMonitor);
        IFolder iFolder5 = buildInfo.getVerifiedLibsFolder(iProgressMonitor);
        Utils.clearContainer((IContainer)iFolder5, iProgressMonitor);
        IFolder iFolder6 = buildInfo.getRuntimeFolder(iProgressMonitor);
        if (iFolder6.exists()) {
            PreverificationBuilder.deleteRuntimeJar(iProject, iProgressMonitor);
            Utils.clearContainer((IContainer)iFolder6, iProgressMonitor);
        }
        if (bl && (iFolder = PreverificationBuilder.getDeploymentFolder(iProject, iProgressMonitor)).exists()) {
            Utils.clearContainer((IContainer)iFolder, iProgressMonitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.cleanProject project = " + iProject);
        }
    }

    public static de.schlichtherle.io.File getRuntimeJar(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.getRuntimeJar project = " + iProject);
        }
        if ((file = runtimeJars.get(iProject)) == null) {
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                BuildConsoleProxy.instance.traceln("- PreverificationBuilder.getRuntimeJar JAR file not in cache");
            }
            IFolder iFolder = iProject.getFolder(".mtj.tmp");
            IFolder iFolder2 = iFolder.getFolder("emulation");
            PreverificationBuilder.createFolders(iFolder2, iProgressMonitor);
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
            file = new de.schlichtherle.io.File(iFolder2.getLocation().toFile(), iMidletSuiteProject.getJarFilename());
            file.mkdir();
            iFolder2.refreshLocal(1, iProgressMonitor);
            runtimeJars.put(iProject, file);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.getRuntimeJar project = " + iProject);
        }
        return file;
    }

    private static void deleteRuntimeJar(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file;
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.deleteRuntimeJar project = " + iProject);
        }
        if ((file = runtimeJars.remove(iProject)) != null && file.exists()) {
            try {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    BuildConsoleProxy.instance.traceln("- PreverificationBuilder.deleteRuntimeJar jar = " + file);
                }
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                file.deleteAll();
                file.delete();
                IFolder iFolder = iProject.getFolder(".mtj.tmp");
                IFolder iFolder2 = iFolder.getFolder("emulation");
                iFolder2.refreshLocal(1, iProgressMonitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                throw coreException;
            }
            catch (ArchiveException archiveException) {
                archiveException.printStackTrace();
                MTJCorePlugin.throwCoreException(4, -999, archiveException);
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.deleteRuntimeJar project = " + iProject);
        }
    }

    private static IFolder getDeploymentFolder(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = MTJCorePlugin.getDeploymentDirectoryName();
        IFolder iFolder = iProject.getFolder(string);
        if (!iFolder.exists()) {
            iFolder.create(false, true, iProgressMonitor);
        }
        return iFolder;
    }

    static void createFolders(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.createFolders folder = " + iFolder);
        }
        while (!iFolder.exists()) {
            if (iFolder.getParent().getType() == 2) {
                PreverificationBuilder.createFolders((IFolder)iFolder.getParent(), iProgressMonitor);
            }
            iFolder.create(true, true, iProgressMonitor);
            iFolder.setDerived(true);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.createFolders folder = " + iFolder);
        }
    }

    static void generateDeployedManifest(IMidletSuiteProject iMidletSuiteProject, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        ApplicationDescriptor.MidletDefinition midletDefinition2;
        Object object2;
        IProject iProject = iMidletSuiteProject.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.generateDeployedManifest project = " + iProject);
        }
        if (!iMidletSuiteProject.getApplicationDescriptorFile().exists()) {
            BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest exiting early since " + iMidletSuiteProject.getApplicationDescriptorFile().getName() + " does not exist");
            return;
        }
        ApplicationDescriptor applicationDescriptor = iMidletSuiteProject.getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = applicationDescriptor.getManifestProperties();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest filtering excluded properties");
        }
        String[] stringArray = PreferenceAccessor.instance.getExcludedManifestProperties(iProject);
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            if (colonDelimitedProperties.containsKey(object2)) {
                colonDelimitedProperties.remove(object2);
            }
            ++n;
        }
        Manifest manifest = new Manifest();
        object2 = manifest.getMainAttributes();
        ((Attributes)object2).putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest setting properties into Manifest object");
        }
        for (Map.Entry<Object, Object> object3 : colonDelimitedProperties.entrySet()) {
            try {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest -- " + object3.getKey() + " -> " + object3.getValue());
                }
                ((Attributes)object2).putValue((String)object3.getKey(), (String)object3.getValue());
            }
            catch (IllegalArgumentException midletDefinition2) {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest exception: " + midletDefinition2);
                }
                Status object4 = new Status(4, "org.eclipse.mtj.core", -999, "Illegal Manifest Entry Key or Value \"" + midletDefinition2.getMessage() + "\"", (Throwable)midletDefinition2);
                throw new CoreException((IStatus)object4);
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest setting MIDlet definitions");
        }
        for (ApplicationDescriptor.MidletDefinition midletDefinition2 : applicationDescriptor.getMidletDefinitions()) {
            object = "MIDlet-" + midletDefinition2.getNumber();
            String iOException = midletDefinition2.toString();
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest -- " + (String)object + " -> " + iOException);
            }
            ((Attributes)object2).putValue((String)object, iOException);
        }
        midletDefinition2 = null;
        object = new de.schlichtherle.io.File((File)PreverificationBuilder.getRuntimeJar(iProject, iProgressMonitor), "META-INF/MANIFEST.MF");
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest writing manifest file: " + object);
        }
        try {
            try {
                midletDefinition2 = new FileOutputStream((File)object);
                manifest.write((OutputStream)((Object)midletDefinition2));
            }
            catch (IOException iOException) {
                if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                    BuildConsoleProxy.instance.traceln("- PreverificationBuilder.generateDeployedManifest exception: " + iOException);
                }
                Status status = new Status(4, "org.eclipse.mtj.core", -999, "Illegal Manifest Entry Key or Value \"" + iOException.getMessage() + "\"", (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (midletDefinition2 != null) {
                try {
                    midletDefinition2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (midletDefinition2 != null) {
            try {
                midletDefinition2.close();
            }
            catch (IOException iOException) {}
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.generateDeployedManifest suite = " + iMidletSuiteProject.getProject());
        }
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        int n2;
        boolean bl;
        IJavaProject iJavaProject;
        IProject iProject = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.build project = " + iProject);
        }
        IJavaProject iJavaProject2 = iJavaProject = JavaCore.create((IProject)iProject);
        IJavaProject[] iJavaProjectArray = this.getRequiredProjects(iJavaProject2, iProgressMonitor);
        iProgressMonitor.beginTask("Preverification", iJavaProjectArray.length + 1);
        BuildInfo buildInfo = new BuildInfo(n, map, iJavaProject2);
        boolean bl2 = bl = PreferenceAccessor.instance.getAutoversionPackage(iProject) && buildInfo.isBuildArgumentTrue(ARG_UPDATE_VERSION);
        if (bl) {
            this.updateJADVersion(buildInfo, iProgressMonitor);
        } else {
            PreverificationBuilder.generateDeployedManifest(buildInfo.getMidletSuite(), iProgressMonitor);
        }
        this.preverifyProject(buildInfo, iProgressMonitor);
        int n3 = 0;
        while (n3 < iJavaProjectArray.length) {
            iJavaProject2 = iJavaProjectArray[n3];
            if (iJavaProject2 != null) {
                buildInfo.setCurrentJavaProject(iJavaProject2);
                this.preverifyProject(buildInfo, iProgressMonitor);
            }
            ++n3;
        }
        if (buildInfo.isClasspathChanged() && buildInfo.areLibrariesPreverified()) {
            IFolder iFolder = buildInfo.getVerifiedLibsFolder(iProgressMonitor);
            Utils.clearContainer((IContainer)iFolder, iProgressMonitor);
            buildInfo.setCurrentJavaProject(iJavaProject);
            this.preverifyLibraries(buildInfo, iProgressMonitor);
            n2 = 0;
            while (n2 < iJavaProjectArray.length) {
                iJavaProject2 = iJavaProjectArray[n2];
                buildInfo.setCurrentJavaProject(iJavaProject2);
                this.preverifyLibraries(buildInfo, iProgressMonitor);
                ++n2;
            }
        }
        IProject[] iProjectArray = new IProject[iJavaProjectArray.length];
        n2 = 0;
        while (n2 < iJavaProjectArray.length) {
            iProjectArray[n2] = iJavaProjectArray[n2].getProject();
            ++n2;
        }
        if (buildInfo.isPackageDirty()) {
            try {
                de.schlichtherle.io.File file = buildInfo.getRuntimeJarFile(iProgressMonitor);
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            catch (ArchiveException archiveException) {
                MTJCorePlugin.throwCoreException(4, -999, archiveException);
            }
        }
        if (buildInfo.isBuildArgumentTrue(ARG_DO_PACKAGE)) {
            buildInfo.setPackageDirty(true);
            if (buildInfo.isBuildArgumentTrue(ARG_DO_OBFUSCATION)) {
                this.doObfuscation(buildInfo, iProgressMonitor);
            } else {
                this.copyRuntimeJarToDeploymentFolder(buildInfo, iProgressMonitor);
            }
        }
        if (buildInfo.isPackageDirty()) {
            PreverificationBuilder.generateDeployedManifest(buildInfo.getMidletSuite(), iProgressMonitor);
            IFolder iFolder = PreverificationBuilder.getDeploymentFolder(iProject, iProgressMonitor);
            iFolder.refreshLocal(2, iProgressMonitor);
            this.setResourcesAsDerived(buildInfo.getVerifiedClassesFolder(iProgressMonitor), iProgressMonitor);
            this.setResourcesAsDerived(buildInfo.getVerifiedLibsFolder(iProgressMonitor), iProgressMonitor);
            this.setResourcesAsDerived(buildInfo.getRuntimeFolder(iProgressMonitor), iProgressMonitor);
        }
        try {
            de.schlichtherle.io.File file = buildInfo.getRuntimeJarFile(iProgressMonitor);
            de.schlichtherle.io.File.umount((de.schlichtherle.io.File)file, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            this.writeJADFile(buildInfo, file, buildInfo.getRuntimeFolder(iProgressMonitor), true, iProgressMonitor);
            this.getProject().getFolder(".mtj.tmp").refreshLocal(2, iProgressMonitor);
        }
        catch (ArchiveException archiveException) {
            MTJCorePlugin.throwCoreException(4, -999, archiveException);
        }
        iProgressMonitor.done();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.build project = " + iProject);
        }
        return iProjectArray;
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.clean project = " + iProject);
        }
        super.clean(iProgressMonitor);
        PreverificationBuilder.cleanProject(iProject, false, iProgressMonitor);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)this.getProject()));
        PreverificationBuilder.generateDeployedManifest(iMidletSuiteProject, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.clean project = " + iProject);
        }
    }

    private void copyRuntimeJarToDeploymentFolder(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        block18: {
            if (buildLoggingConfig.isPreverifierTraceEnabled()) {
                BuildConsoleProxy.instance.traceln("> PreverificationBuilder.copyRuntimeJarToDeploymentFolder");
            }
            FileInputStream fileInputStream = null;
            try {
                try {
                    de.schlichtherle.io.File file = PreverificationBuilder.getRuntimeJar(this.getProject(), iProgressMonitor);
                    fileInputStream = new FileInputStream((File)file);
                    IFolder iFolder = this.getDeploymentFolder(buildInfo, iProgressMonitor);
                    IFile iFile = iFolder.getFile(file.getName());
                    if (iFile.exists()) {
                        iFile.setContents((InputStream)fileInputStream, true, false, iProgressMonitor);
                    } else {
                        iFile.create((InputStream)fileInputStream, true, iProgressMonitor);
                    }
                    this.writeJADFile(buildInfo, new de.schlichtherle.io.File(iFile.getLocation().toFile()), iFolder, false, iProgressMonitor);
                }
                catch (IOException iOException) {
                    MTJCorePlugin.throwCoreException(4, 999, iOException);
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.copyRuntimeJarToDeploymentFolder");
        }
    }

    private void doObfuscation(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.doObfuscation");
        }
        final StringBuffer stringBuffer = new StringBuffer();
        de.schlichtherle.io.File file = buildInfo.getRuntimeJarFile(iProgressMonitor);
        BuildConsoleProxy.instance.traceln("Obfuscating " + file);
        Path path = new Path(file.getAbsolutePath());
        String string = path.lastSegment();
        string = string.substring(0, string.length() - 4);
        IFolder iFolder = this.getDeploymentFolder(buildInfo, iProgressMonitor);
        IFile iFile = iFolder.getFile(String.valueOf(string) + "_obf.jar");
        IFile iFile2 = iFolder.getFile(path.lastSegment());
        BuildConsoleProxy.instance.traceln("Obfuscating to output jar " + iFile.getLocation().toFile());
        ObfuscatorTool obfuscatorTool = new ObfuscatorTool(buildInfo.getMidletSuite(), (File)file, iFile.getLocation().toFile());
        ILaunch iLaunch = obfuscatorTool.launch(iProgressMonitor);
        StringBuffer stringBuffer2 = new StringBuffer();
        IProcess[] iProcessArray = iLaunch.getProcesses();
        if (iProcessArray != null && iProcessArray.length > 0) {
            IProcess iProcess = iProcessArray[0];
            IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
            if (buildLoggingConfig.isObfuscationOutputEnabled()) {
                BuildConsoleProxy.instance.traceln("======================== Launching Obfuscation =========================");
                BuildConsoleProxy.instance.addConsoleStreamListener("error", iStreamsProxy.getErrorStreamMonitor());
                BuildConsoleProxy.instance.addConsoleStreamListener("output", iStreamsProxy.getOutputStreamMonitor());
            }
            iStreamsProxy.getErrorStreamMonitor().addListener(new IStreamListener(){

                public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                    stringBuffer.append(string);
                }
            });
            while (!iProgressMonitor.isCanceled() && !iProcess.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (buildLoggingConfig.isObfuscationOutputEnabled()) {
                BuildConsoleProxy.instance.traceln("======================== Obfuscation exited with code: " + iProcess.getExitValue());
            }
            if (stringBuffer2.length() > 0) {
                MTJCorePlugin.log(1, stringBuffer2.toString());
            }
            boolean bl = true;
            if (stringBuffer.length() > 0) {
                String string2 = stringBuffer.toString();
                Status status = new Status(4, "org.eclipse.mtj.core", 101, string2, null);
                Boolean bl2 = (Boolean)MTJCorePlugin.statusPrompt((IStatus)status, (Object)this);
                boolean bl3 = bl = bl2 != null ? bl2 : false;
            }
            if (bl) {
                this.doPostObfuscationPreverification(buildInfo, iFile, iFile2, iProgressMonitor);
            }
        }
        this.writeJADFile(buildInfo, new de.schlichtherle.io.File(iFile2.getLocation().toFile()), iFolder, false, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.doObfuscation");
        }
    }

    private void doPostObfuscationPreverification(BuildInfo buildInfo, IFile iFile, IFile iFile2, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.doPostObfuscationPreverification");
            BuildConsoleProxy.instance.traceln("- Obfuscated jar: " + iFile.getLocation().toFile());
            BuildConsoleProxy.instance.traceln("- Deployed jar file: " + iFile2.getLocation().toFile());
        }
        try {
            IFolder iFolder = (IFolder)iFile.getParent();
            IFolder iFolder2 = iFolder.getFolder("temp");
            if (!iFolder2.exists()) {
                iFolder2.create(true, true, iProgressMonitor);
            }
            BuildConsoleProxy.instance.traceln("Preverifying obfuscated jar into " + iFolder2.getLocation().toFile());
            de.schlichtherle.io.File file = new de.schlichtherle.io.File(iFile.getLocation().toFile());
            PreverificationError[] preverificationErrorArray = buildInfo.getMidletSuite().preverifyJarFile((File)file, iFolder2, iProgressMonitor);
            iFolder2.refreshLocal(1, iProgressMonitor);
            if (preverificationErrorArray.length > 0) {
                BuildConsoleProxy.instance.traceln(String.valueOf(preverificationErrorArray.length) + " errors occurred during post-obfuscation preverification");
                this.handlePreverificationErrors(preverificationErrorArray);
            }
            IFile iFile3 = this.getJarFile(buildInfo, iFolder, false);
            IFile iFile4 = iFolder2.getFile(iFile.getName());
            Utils.copyFile(iFile4, iFile3);
            BuildConsoleProxy.instance.traceln("Copying " + iFile4 + " to " + iFile3.getLocation().toFile());
            BuildConsoleProxy.instance.traceln("Deleting " + iFile4.getLocation().toFile());
            iFile4.delete(true, iProgressMonitor);
            BuildConsoleProxy.instance.traceln("Deleting " + iFolder2.getLocation().toFile());
            iFolder2.delete(true, iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJCorePlugin.throwCoreException(4, 999, iOException);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.doPostObfuscationPreverification");
        }
    }

    private IFolder getDeploymentFolder(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        return PreverificationBuilder.getDeploymentFolder(buildInfo.getMidletSuite().getProject(), iProgressMonitor);
    }

    private IFile getJarFile(BuildInfo buildInfo, IFolder iFolder, boolean bl) {
        String string = buildInfo.getMidletSuite().getJarFilename();
        if (bl) {
            int n = string.length();
            string = String.valueOf(string.substring(0, n - 4)) + "_base.jar";
        }
        return iFolder.getFile(string);
    }

    private IJavaProject[] getRequiredProjects(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        RequiredProjectsCPEntryVisitor requiredProjectsCPEntryVisitor = new RequiredProjectsCPEntryVisitor();
        requiredProjectsCPEntryVisitor.getRunner().run(iJavaProject, requiredProjectsCPEntryVisitor, iProgressMonitor);
        ArrayList<IJavaProject> arrayList = requiredProjectsCPEntryVisitor.getRequiredProjects();
        return arrayList.toArray(new IJavaProject[arrayList.size()]);
    }

    private int getVersionComponentValue(String string) {
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    private void handlePreverificationErrors(PreverificationError[] preverificationErrorArray) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer("Errors preverifying jar\n");
        int n = 0;
        while (n < preverificationErrorArray.length) {
            if (n != 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(PreverificationUtils.getErrorText(preverificationErrorArray[n]));
            ++n;
        }
        MTJCorePlugin.throwCoreException(4, -999, stringBuffer.toString());
    }

    private void preverifyLibraries(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.preverifyLibraries project = " + iProject);
        }
        if (iProject != null && iProject.isAccessible()) {
            iProgressMonitor.setTaskName("Preverifying " + iProject.getName());
            buildInfo.setCurrentResourceDelta(null);
            if (buildInfo.getBuildKind() != 6) {
                buildInfo.setCurrentResourceDelta(this.getDelta(iProject));
            }
            ResourceDeltaBuilder resourceDeltaBuilder = new ResourceDeltaBuilder(buildInfo);
            resourceDeltaBuilder.preverifyLibraries(iProgressMonitor);
            iProgressMonitor.worked(1);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.preverifyLibraries project = " + iProject);
        }
    }

    private void preverifyProject(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = buildInfo.getCurrentJavaProject().getProject();
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.preverifyProject project = " + iProject);
        }
        if (iProject != null && iProject.isAccessible()) {
            iProgressMonitor.setTaskName("Preverifying " + iProject.getName());
            buildInfo.setCurrentResourceDelta(null);
            if (buildInfo.getBuildKind() != 6) {
                buildInfo.setCurrentResourceDelta(this.getDelta(iProject));
            }
            ResourceDeltaBuilder resourceDeltaBuilder = new ResourceDeltaBuilder(buildInfo);
            resourceDeltaBuilder.build(iProgressMonitor);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.preverifyProject project = " + iProject);
        }
    }

    private void setResourcesAsDerived(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        iFolder.refreshLocal(2, iProgressMonitor);
        MTJCorePlugin.setResourcesAsDerived((IContainer)iFolder);
    }

    private void writeJADFile(BuildInfo buildInfo, de.schlichtherle.io.File file, IFolder iFolder, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.writeJADFile jar = " + file + "; targetFolder = " + iFolder);
        }
        DeployedJADWriter deployedJADWriter = new DeployedJADWriter(buildInfo.getMidletSuite(), iFolder, new File(file.getAbsolutePath()));
        try {
            deployedJADWriter.writeDeployedJAD(bl, iProgressMonitor);
        }
        catch (IOException iOException) {
            MTJCorePlugin.throwCoreException(4, 999, iOException);
        }
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.writeJADFile");
        }
    }

    private void updateJADVersion(BuildInfo buildInfo, IProgressMonitor iProgressMonitor) throws CoreException {
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreverificationBuilder.updateJADVersion");
        }
        ApplicationDescriptor applicationDescriptor = buildInfo.getMidletSuite().getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = applicationDescriptor.getManifestProperties();
        String string = colonDelimitedProperties.getProperty("MIDlet-Version", "0.0.0");
        Version version = new Version(string);
        int n = this.getVersionComponentValue(version.getMajor());
        int n2 = this.getVersionComponentValue(version.getMinor());
        int n3 = this.getVersionComponentValue(version.getSecondary());
        if (n3 >= 99) {
            n3 = 0;
            ++n2;
        } else {
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append(".").append(n2).append(".").append(n3);
        colonDelimitedProperties.setProperty("MIDlet-Version", stringBuffer.toString());
        try {
            applicationDescriptor.store();
        }
        catch (IOException iOException) {
            MTJCorePlugin.throwCoreException(4, 999, iOException);
        }
        PreverificationBuilder.generateDeployedManifest(buildInfo.getMidletSuite(), iProgressMonitor);
        buildInfo.getMidletSuite().getApplicationDescriptorFile().refreshLocal(1, iProgressMonitor);
        if (buildLoggingConfig.isPreverifierTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreverificationBuilder.updateJADVersion");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredProjectsCPEntryVisitor
    extends AbstractClasspathEntryVisitor {
        private ArrayList<IJavaProject> requiredProjects = new ArrayList();

        private RequiredProjectsCPEntryVisitor() {
        }

        public ArrayList<IJavaProject> getRequiredProjects() {
            return this.requiredProjects;
        }

        @Override
        public boolean visitProject(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IJavaProject iJavaProject2, IProgressMonitor iProgressMonitor) throws CoreException {
            boolean bl = iClasspathEntry.isExported();
            if (bl) {
                this.requiredProjects.add(iJavaProject2);
            }
            return bl;
        }
    }
}

