/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preverifier;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.PreferenceAccessor;
import org.eclipse.mtj.core.internal.preverifier.ProgressMonitorPreverificationListener;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.preverifier.ArchivePreverifier;
import org.eclipse.mtj.preverifier.CLDC1_0PreverificationPolicy;
import org.eclipse.mtj.preverifier.CLDC1_1PreverificationPolicy;
import org.eclipse.mtj.preverifier.ClassPreverifier;
import org.eclipse.mtj.preverifier.IArchivePreverificationListener;
import org.eclipse.mtj.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.eclipse.mtj.preverifier.results.PreverificationResults;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedPreverifier
implements IPreverifier {
    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
    }

    @Override
    public PreverificationError[] preverify(IMidletSuiteProject iMidletSuiteProject, IResource[] iResourceArray, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        PreverificationParameters preverificationParameters = new PreverificationParameters(iMidletSuiteProject);
        ArrayList<PreverificationError> arrayList = new ArrayList<PreverificationError>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource instanceof IContainer) {
                this.preverify((IContainer)iResource, iFolder, preverificationParameters, arrayList, iProgressMonitor);
            } else {
                this.preverify((IFile)iResource, iFolder, preverificationParameters, arrayList, iProgressMonitor);
            }
            ++n;
        }
        return arrayList.toArray(new PreverificationError[arrayList.size()]);
    }

    @Override
    public PreverificationError[] preverifyJarFile(IMidletSuiteProject iMidletSuiteProject, File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        PreverificationParameters preverificationParameters = new PreverificationParameters(iMidletSuiteProject);
        ProgressMonitorPreverificationListener progressMonitorPreverificationListener = new ProgressMonitorPreverificationListener(iProgressMonitor);
        ArchivePreverifier archivePreverifier = new ArchivePreverifier(preverificationParameters.getPreverificationPolicy(), (IArchivePreverificationListener)progressMonitorPreverificationListener);
        IFile iFile = iFolder.getFile(file.getName());
        archivePreverifier.preverify(file, iFile.getLocation().toFile(), preverificationParameters.getClasspath());
        List<PreverificationError> list = progressMonitorPreverificationListener.getErrorList();
        return list.toArray(new PreverificationError[list.size()]);
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
    }

    private void preverify(IContainer iContainer, IFolder iFolder, PreverificationParameters preverificationParameters, List<PreverificationError> list, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        IResource[] iResourceArray = iContainer.members();
        int n = 0;
        while (n < iResourceArray.length) {
            IFolder iFolder2;
            IResource iResource = iResourceArray[n];
            if (iResource.getType() == 2) {
                iFolder2 = (IFolder)iResource;
                IFolder iFolder3 = iFolder2.getFolder(iFolder2.getName());
                this.preverify((IContainer)iFolder2, iFolder3, preverificationParameters, list, iProgressMonitor);
            } else {
                iFolder2 = (IFile)iResource;
                this.preverify((IFile)iFolder2, iFolder, preverificationParameters, list, iProgressMonitor);
            }
            ++n;
        }
    }

    private void preverify(IFile iFile, IFolder iFolder, PreverificationParameters preverificationParameters, List<PreverificationError> list, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        URL[] uRLArray;
        InputStream inputStream;
        ClassPreverifier classPreverifier = preverificationParameters.getClassPreverifier();
        PreverificationResults preverificationResults = classPreverifier.preverify(inputStream = iFile.getContents(), uRLArray = preverificationParameters.getClasspath());
        if (preverificationResults.isErrorResult()) {
            list.addAll((Collection<PreverificationError>)Arrays.asList(preverificationResults.getErrors()));
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(preverificationResults.getPreverifiedClassBytes());
            IFolder iFolder2 = this.createPackageFolder(iFolder, preverificationResults, iProgressMonitor);
            IFile iFile2 = iFolder2.getFile(iFile.getName());
            if (!iFile2.exists()) {
                iFile2.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
            } else {
                iFile2.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
            }
        }
    }

    private IFolder createPackageFolder(IFolder iFolder, PreverificationResults preverificationResults, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = preverificationResults.getPreverifiedClassNode().name;
        String[] stringArray = string.split("/");
        IFolder iFolder2 = iFolder;
        int n = 0;
        while (n < stringArray.length - 1) {
            String string2 = stringArray[n];
            if (!(iFolder2 = iFolder2.getFolder(string2)).exists()) {
                iFolder2.create(true, true, iProgressMonitor);
            }
            ++n;
        }
        return iFolder2;
    }

    private static class PreverificationParameters {
        private IMidletSuiteProject midletSuite;
        private IPreverificationPolicy preverificationPolicy;
        private ClassPreverifier classPreverifier;

        PreverificationParameters(IMidletSuiteProject iMidletSuiteProject) {
            this.midletSuite = iMidletSuiteProject;
        }

        protected ArchivePreverifier getArchivePreverifier(IProgressMonitor iProgressMonitor) {
            ProgressMonitorPreverificationListener progressMonitorPreverificationListener = new ProgressMonitorPreverificationListener(iProgressMonitor);
            ArchivePreverifier archivePreverifier = new ArchivePreverifier(this.getPreverificationPolicy(), (IArchivePreverificationListener)progressMonitorPreverificationListener);
            return archivePreverifier;
        }

        protected IMidletSuiteProject getMidletSuite() {
            return this.midletSuite;
        }

        protected IPreverificationPolicy getPreverificationPolicy() {
            if (this.preverificationPolicy == null) {
                IProject iProject = this.midletSuite.getProject();
                Version version = null;
                try {
                    version = PreferenceAccessor.instance.getPreverificationConfigurationVersion(iProject);
                }
                catch (CoreException coreException) {
                    MTJCorePlugin.log(4, coreException.getMessage(), coreException);
                }
                Version version2 = new Version("1.1");
                this.preverificationPolicy = version != null && version.equals(version2) ? new CLDC1_1PreverificationPolicy() : new CLDC1_0PreverificationPolicy();
            }
            return this.preverificationPolicy;
        }

        protected ClassPreverifier getClassPreverifier() {
            if (this.classPreverifier == null) {
                this.classPreverifier = new ClassPreverifier(this.getPreverificationPolicy());
            }
            return this.classPreverifier;
        }

        protected URL[] getClasspath() throws CoreException, IOException {
            IJavaProject iJavaProject = this.midletSuite.getJavaProject();
            String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)iJavaProject);
            URL[] uRLArray = new URL[stringArray.length + 1];
            uRLArray[0] = this.getEmptyAPI();
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(stringArray[n]);
                uRLArray[n + 1] = file.toURI().toURL();
                ++n;
            }
            return uRLArray;
        }

        protected URL getEmptyAPI() throws IOException {
            Bundle bundle = MTJCorePlugin.getDefault().getBundle();
            URL uRL = bundle.getEntry("lib/emptyapi.zip");
            return FileLocator.resolve((URL)uRL);
        }
    }
}

