/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.IClasspathEntryVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathEntryVisitorRunner {
    private boolean breadthFirst;

    public ClasspathEntryVisitorRunner() {
        this(false);
    }

    public ClasspathEntryVisitorRunner(boolean bl) {
        this.breadthFirst = bl;
    }

    public void run(IJavaProject iJavaProject, IClasspathEntryVisitor iClasspathEntryVisitor, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iJavaProject != null) {
            ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                this.visitEntry(iJavaProject, iClasspathEntry, iClasspathEntryVisitor, arrayList, iProgressMonitor);
                ++n;
            }
            for (IJavaProject iJavaProject2 : arrayList) {
                this.run(iJavaProject2, iClasspathEntryVisitor, iProgressMonitor);
            }
        }
    }

    private void visitEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IClasspathEntryVisitor iClasspathEntryVisitor, ArrayList<IJavaProject> arrayList, IProgressMonitor iProgressMonitor) throws CoreException {
        switch (iClasspathEntry.getEntryKind()) {
            case 5: {
                this.visitContainerEntry(iJavaProject, iClasspathEntry, iClasspathEntryVisitor, arrayList, iProgressMonitor);
                break;
            }
            case 1: {
                this.visitLibraryEntry(iJavaProject, iClasspathEntry, iClasspathEntryVisitor, iProgressMonitor);
                break;
            }
            case 2: {
                this.visitProjectEntry(iJavaProject, iClasspathEntry, iClasspathEntryVisitor, arrayList, iProgressMonitor);
                break;
            }
            case 3: {
                this.visitSourceEntry(iJavaProject, iClasspathEntry, iClasspathEntryVisitor, iProgressMonitor);
                break;
            }
            case 4: {
                this.visitVariableEntry(iJavaProject, iClasspathEntry, iClasspathEntryVisitor, arrayList, iProgressMonitor);
            }
        }
    }

    private void visitContainerEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IClasspathEntryVisitor iClasspathEntryVisitor, ArrayList<IJavaProject> arrayList, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath = iClasspathEntry.getPath();
        if (iClasspathEntryVisitor.visitContainerBegin(iClasspathEntry, iJavaProject, iPath, iProgressMonitor)) {
            IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
            IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IClasspathEntry iClasspathEntry2 = iClasspathEntryArray[n];
                this.visitEntry(iJavaProject, iClasspathEntry2, iClasspathEntryVisitor, arrayList, iProgressMonitor);
                ++n;
            }
        }
    }

    private void visitLibraryEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IClasspathEntryVisitor iClasspathEntryVisitor, IProgressMonitor iProgressMonitor) throws CoreException {
        iClasspathEntryVisitor.visitLibraryEntry(iClasspathEntry, iJavaProject, iProgressMonitor);
    }

    private void visitProjectEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IClasspathEntryVisitor iClasspathEntryVisitor, ArrayList<IJavaProject> arrayList, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath = iClasspathEntry.getPath();
        IProject iProject = (IProject)MTJCorePlugin.getWorkspace().getRoot().findMember(iPath);
        IJavaProject iJavaProject2 = JavaCore.create((IProject)iProject);
        if (iClasspathEntryVisitor.visitProject(iClasspathEntry, iJavaProject, iJavaProject2, iProgressMonitor)) {
            if (this.breadthFirst) {
                arrayList.add(iJavaProject2);
            } else {
                this.run(iJavaProject2, iClasspathEntryVisitor, iProgressMonitor);
            }
        }
    }

    private void visitSourceEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IClasspathEntryVisitor iClasspathEntryVisitor, IProgressMonitor iProgressMonitor) throws CoreException {
        iClasspathEntryVisitor.visitSourceEntry(iClasspathEntry, iJavaProject, iProgressMonitor);
    }

    private void visitVariableEntry(IJavaProject iJavaProject, IClasspathEntry iClasspathEntry, IClasspathEntryVisitor iClasspathEntryVisitor, ArrayList<IJavaProject> arrayList, IProgressMonitor iProgressMonitor) throws CoreException {
        String string = iClasspathEntry.getPath().lastSegment();
        if (iClasspathEntryVisitor.visitVariable(iClasspathEntry, iJavaProject, string, iProgressMonitor)) {
            IClasspathEntry iClasspathEntry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
            this.visitEntry(iJavaProject, iClasspathEntry2, iClasspathEntryVisitor, arrayList, iProgressMonitor);
        }
    }
}

