/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.impl;

import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class VMInstallClasspath
extends Classpath {
    private boolean prependVMLibraries;
    private ILibrary[] entriesCache;

    public ILibrary[] getEntries() {
        if (this.entriesCache == null) {
            this.entriesCache = this.calculateEntries();
        }
        return this.entriesCache;
    }

    public boolean isPrependVMLibraries() {
        return this.prependVMLibraries;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        iPersistenceProvider.loadBoolean("prependVMLibraries");
    }

    public void setPrependVMLibraries(boolean bl) {
        this.prependVMLibraries = bl;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeBoolean("prependVMLibraries", this.prependVMLibraries);
    }

    private ILibrary[] calculateEntries() {
        ILibrary[] iLibraryArray = super.getEntries();
        LibraryLocation[] libraryLocationArray = JavaRuntime.getLibraryLocations((IVMInstall)JavaRuntime.getDefaultVMInstall());
        int n = this.prependVMLibraries ? 0 : iLibraryArray.length;
        int n2 = this.prependVMLibraries ? iLibraryArray.length : 0;
        ILibrary[] iLibraryArray2 = new ILibrary[iLibraryArray.length + libraryLocationArray.length];
        System.arraycopy(iLibraryArray, 0, iLibraryArray2, n2, iLibraryArray.length);
        LibraryImporter libraryImporter = new LibraryImporter();
        int n3 = 0;
        while (n3 < libraryLocationArray.length) {
            iLibraryArray2[n++] = libraryImporter.createLibraryFor(libraryLocationArray[n3].getSystemLibraryPath().toFile());
            ++n3;
        }
        return iLibraryArray2;
    }
}

