/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.jad;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.model.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor {
    public static final String MIDLET_PREFIX = "MIDlet-";
    private ColonDelimitedProperties manifestProperties;
    private List<MidletDefinition> midletDefinitions;
    private File sourceFile;

    public ApplicationDescriptor(File file) throws IOException {
        this.sourceFile = file;
        this.midletDefinitions = new ArrayList<MidletDefinition>();
        this.parseDescriptor(file);
    }

    public void addMidletDefinition(MidletDefinition midletDefinition) {
        this.midletDefinitions.add(midletDefinition);
    }

    private ColonDelimitedProperties copyProperties() {
        ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
        for (String string : this.manifestProperties.keySet()) {
            String string2 = this.manifestProperties.getProperty(string);
            colonDelimitedProperties.setProperty(string, string2);
        }
        return colonDelimitedProperties;
    }

    public Version getConfigurationSpecificationVersion() throws CoreException {
        String[] stringArray;
        Version version = null;
        String string = this.manifestProperties.getProperty("MicroEdition-Configuration");
        if (string != null && (stringArray = string.split("-")).length == 2) {
            version = new Version(stringArray[1]);
        }
        if (version == null) {
            version = new Version("1.0");
        }
        return version;
    }

    public ColonDelimitedProperties getManifestProperties() {
        return this.manifestProperties;
    }

    public int getMidletCount() {
        return this.midletDefinitions.size();
    }

    public List<MidletDefinition> getMidletDefinitions() {
        return this.midletDefinitions;
    }

    public String getMidletJarURL() {
        String string = null;
        if (this.manifestProperties != null) {
            string = this.manifestProperties.getProperty("MIDlet-Jar-URL");
        }
        return string;
    }

    private void parseDescriptor(File file) throws IOException {
        this.manifestProperties = new ColonDelimitedProperties();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.manifestProperties.load(fileInputStream);
            this.parseMidletDefinitions();
        }
    }

    private void parseMidletDefinitions() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.manifestProperties.size());
        for (Object object : this.manifestProperties.keySet()) {
            if (!((String)object).startsWith(MIDLET_PREFIX)) continue;
            int n = -1;
            try {
                n = Integer.parseInt(((String)object).substring(MIDLET_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {}
            if (n == -1) continue;
            String string = this.manifestProperties.getProperty((String)object);
            this.midletDefinitions.add(new MidletDefinition(n, string));
            arrayList.add(object);
        }
        for (String string : arrayList) {
            this.manifestProperties.remove(string);
        }
    }

    public void store() throws IOException {
        this.store(this.sourceFile);
    }

    public void store(File file) throws IOException {
        ColonDelimitedProperties colonDelimitedProperties = this.copyProperties();
        for (MidletDefinition object2 : this.midletDefinitions) {
            String throwable = MIDLET_PREFIX + object2.getNumber();
            String string = object2.toString();
            colonDelimitedProperties.setProperty(throwable, string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            colonDelimitedProperties.store(fileOutputStream, "MIDlet Property Definitions");
        }
        catch (Throwable throwable) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static class MidletDefinition {
        private String className;
        private String icon;
        private String name;
        private int number;

        MidletDefinition(int n, String string) {
            int n2 = 0;
            this.number = n;
            this.name = "";
            this.icon = "";
            this.className = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(",")) {
                    ++n2;
                    continue;
                }
                switch (n2) {
                    case 0: {
                        this.name = string2;
                        break;
                    }
                    case 1: {
                        this.icon = string2;
                        break;
                    }
                    case 2: {
                        this.className = string2;
                    }
                }
            }
        }

        public MidletDefinition(int n, String string, String string2, String string3) {
            this.number = n;
            this.name = string;
            this.icon = string2;
            this.className = string3;
        }

        public String getClassName() {
            return this.className;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setIcon(String string) {
            this.icon = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append(',');
            stringBuffer.append(this.icon).append(',');
            stringBuffer.append(this.className);
            return stringBuffer.toString();
        }
    }
}

