/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.library.api;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.library.api.APIRegistry;
import org.eclipse.mtj.core.model.library.api.APIType;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class API
implements IPersistable {
    private String identifier;
    private String name;
    private Version version;
    private APIType type;
    private boolean registered;
    private String primaryMatchableClass;
    private URL[] skeletonReplacements;

    public API() {
        this.type = APIType.UNKNOWN;
    }

    public API(IConfigurationElement iConfigurationElement) throws IOException {
        this.registered = true;
        this.identifier = iConfigurationElement.getAttribute("id");
        this.name = iConfigurationElement.getAttribute("name");
        if (this.name == null) {
            this.name = this.identifier;
        }
        this.primaryMatchableClass = iConfigurationElement.getAttribute("primaryClass");
        String string = iConfigurationElement.getAttribute("version");
        if (string == null) {
            string = "1.0";
        }
        this.version = new Version(string);
        String string2 = iConfigurationElement.getAttribute("type");
        this.type = "profile".equals(string2) ? APIType.PROFILE : ("configuration".equals(string2) ? APIType.CONFIGURATION : APIType.OPTIONAL);
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("skeletonFile");
        this.skeletonReplacements = new URL[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            Path path = new Path(iConfigurationElement2.getAttribute("path"));
            if (path.isAbsolute()) {
                this.skeletonReplacements[n] = path.toFile().toURI().toURL();
            } else {
                String string3 = iConfigurationElement2.getNamespaceIdentifier();
                this.skeletonReplacements[n] = new URL("platform:///plugin/" + string3 + "/" + path);
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        return object instanceof API && this.equalsAPI((API)object);
    }

    public int hashCode() {
        return this.identifier.hashCode() ^ this.type.hashCode() ^ this.version.hashCode();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryMatchableClass() {
        return this.primaryMatchableClass;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPrimaryMatchableClass(String string) {
        this.primaryMatchableClass = string;
    }

    public APIType getType() {
        return this.type;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean bl) {
        this.registered = bl;
    }

    public URL[] getSkeletonReplacements() {
        return this.skeletonReplacements;
    }

    public void setType(APIType aPIType) {
        this.type = aPIType;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setSkeletonReplacements(URL[] uRLArray) {
        this.skeletonReplacements = uRLArray;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean isConfiguration() {
        return this.type == APIType.CONFIGURATION;
    }

    public boolean isProfile() {
        return this.type == APIType.PROFILE;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.identifier = iPersistenceProvider.loadString("identifier");
        this.version = new Version(iPersistenceProvider.loadString("version"));
        this.registered = iPersistenceProvider.loadBoolean("registered");
        API aPI = null;
        if (this.registered) {
            aPI = APIRegistry.getAPI(this.identifier, this.version);
        }
        if (aPI != null) {
            this.name = aPI.name;
            this.type = aPI.type;
            this.primaryMatchableClass = aPI.primaryMatchableClass;
            this.skeletonReplacements = aPI.skeletonReplacements;
        } else {
            this.name = iPersistenceProvider.loadString("name");
            int n = iPersistenceProvider.loadInteger("type");
            this.type = APIType.typeForCode(n);
        }
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storeString("identifier", this.identifier);
        iPersistenceProvider.storeString("name", this.name);
        iPersistenceProvider.storeInteger("type", this.type.getTypeCode());
        iPersistenceProvider.storeString("version", this.version.toString());
        iPersistenceProvider.storeBoolean("registered", this.registered);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.identifier);
        stringBuffer.append("-").append(this.version);
        return stringBuffer.toString();
    }

    private boolean equalsAPI(API aPI) {
        return this.identifier.equals(aPI.identifier) && this.type.equals(aPI.type) && this.version.equals(aPI.version);
    }
}

