/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.nature.BuildSpecManipulator;

public class PreprocessedProjectMigrationRunnable
implements IWorkspaceRunnable {
    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject[] iProjectArray;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray2 = iProjectArray = iWorkspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (iProject.isOpen()) {
                this.migrateProject(iProject, iProgressMonitor);
            }
            ++n2;
        }
    }

    private void migratePreprocessingProject(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        BuildSpecManipulator buildSpecManipulator = new BuildSpecManipulator(iProject);
        if (!buildSpecManipulator.hasBuilder("org.eclipse.jdt.core.javabuilder")) {
            buildSpecManipulator.addBuilderBefore("org.eclipse.mtj.core.preverifier", "org.eclipse.jdt.core.javabuilder", null);
        }
        if (!buildSpecManipulator.hasBuilder("org.eclipse.mtj.core.preprocessor")) {
            buildSpecManipulator.addBuilderBefore("org.eclipse.jdt.core.javabuilder", "org.eclipse.mtj.core.preprocessor", null);
        }
        if (buildSpecManipulator.hasArguments("org.eclipse.mtj.core.preverifier")) {
            buildSpecManipulator.replaceBuilder("org.eclipse.mtj.core.preverifier", null);
        }
        buildSpecManipulator.commitChanges(iProgressMonitor);
    }

    private void migrateProject(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProject.hasNature("org.eclipse.mtj.core.preprocessingNature")) {
            this.migratePreprocessingProject(iProject, iProgressMonitor);
        } else if (iProject.hasNature("org.eclipse.mtj.core.preprocessedNature")) {
            iProject.delete(true, iProgressMonitor);
        }
    }
}

