/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.core.MTJCoreStrings;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.device.IDevice2;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;

public class EmulatorRunner
extends AbstractVMRunner {
    private IMidletSuiteProject suite;
    private IDevice device;
    private boolean debugMode;

    private static String renderDebugTarget(String string, int n) {
        return MTJCoreStrings.getString("debugvmrunner.debug_target_string", new String[]{string, String.valueOf(n)});
    }

    public static String renderProcessLabel(String[] stringArray) {
        String string = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MTJCoreStrings.getString("debugvmrunner.process_label_string", new String[]{stringArray[0], string});
    }

    private static String renderCommandLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 1) {
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public EmulatorRunner(IMidletSuiteProject iMidletSuiteProject, IDevice iDevice, String string) {
        this.suite = iMidletSuiteProject;
        this.device = iDevice;
        this.debugMode = "debug".equals(string);
    }

    public void run(VMRunnerConfiguration vMRunnerConfiguration, ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.debugMode) {
            this.runInDebug(vMRunnerConfiguration, iLaunchConfiguration, iLaunch, iProgressMonitor);
        } else {
            this.runWithoutDebug(vMRunnerConfiguration, iLaunchConfiguration, iLaunch, iProgressMonitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runInDebug(VMRunnerConfiguration vMRunnerConfiguration, ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
        subProgressMonitor.beginTask(MTJCoreStrings.getString("debugvmrunner.launching_vm"), 4);
        subProgressMonitor.subTask(MTJCoreStrings.getString("debugvmrunner.finding_free_socket"));
        int n = SocketUtil.findFreePort();
        if (n == -1) {
            this.abort(MTJCoreStrings.getString("debugvmrunner.no_free_socket"), null, 118);
        }
        subProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        subProgressMonitor.subTask(MTJCoreStrings.getString("debugvmrunner.constructing_cmd_line"));
        String[] stringArray = this.getCommandLine(iLaunchConfiguration, n, iProgressMonitor);
        Utils.dumpCommandLine(stringArray);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        subProgressMonitor.worked(1);
        subProgressMonitor.subTask(MTJCoreStrings.getString("debugvmrunner.starting_VM"));
        Connector connector = this.getConnector();
        if (connector == null) {
            this.abort(MTJCoreStrings.getString("debugvmrunner.no_connector"), null, 119);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        this.specifyArguments(map, n);
        Process process = null;
        try {
            try {
                File file;
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                if (!this.device.isDebugServer()) {
                    ((ListeningConnector)connector).startListening(map);
                }
                if ((process = this.exec(stringArray, file = this.getWorkingDir(vMRunnerConfiguration))) == null) {
                    return;
                }
                if (iProgressMonitor.isCanceled()) {
                    process.destroy();
                    return;
                }
                IProcess iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)EmulatorRunner.renderProcessLabel(stringArray), (Map)this.getDefaultProcessMap());
                iProcess.setAttribute(IProcess.ATTR_CMDLINE, EmulatorRunner.renderCommandLine(stringArray));
                subProgressMonitor.worked(1);
                subProgressMonitor.subTask(MTJCoreStrings.getString("debugvmrunner.establishing_debug_conn"));
                VirtualMachine virtualMachine = this.createVirtualMachine(connector, map, process, iProcess, iProgressMonitor);
                JDIDebugModel.newDebugTarget((ILaunch)iLaunch, (VirtualMachine)virtualMachine, (String)EmulatorRunner.renderDebugTarget(vMRunnerConfiguration.getClassToLaunch(), n), (IProcess)iProcess, (boolean)true, (boolean)false);
                subProgressMonitor.worked(1);
                subProgressMonitor.done();
                return;
            }
            finally {
                if (!this.device.isDebugServer()) {
                    ((ListeningConnector)connector).stopListening(map);
                }
            }
        }
        catch (IOException iOException) {
            this.abort(MTJCoreStrings.getString("debugvmrunner.couldnt_connect_to_vm"), iOException, 120);
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            this.abort(MTJCoreStrings.getString("debugvmrunner.couldnt_connect_to_vm"), illegalConnectorArgumentsException, 120);
        }
        if (process == null) return;
        process.destroy();
    }

    private VirtualMachine createVirtualMachine(Connector connector, Map map, Process process, IProcess iProcess, IProgressMonitor iProgressMonitor) throws IOException, IllegalConnectorArgumentsException, CoreException {
        VirtualMachine virtualMachine = this.device.isDebugServer() ? this.waitForRemoteDebugger((AttachingConnector)connector, map) : this.waitForDebuggerConnection((ListeningConnector)connector, process, iProcess, map, iProgressMonitor);
        return virtualMachine;
    }

    private Connector getConnector() {
        Connector connector = this.device.isDebugServer() ? this.getAttachingConnector() : this.getListeningConnector();
        return connector;
    }

    private VirtualMachine waitForRemoteDebugger(AttachingConnector attachingConnector, Map map) throws IOException, IllegalConnectorArgumentsException, CoreException {
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        VirtualMachine virtualMachine = null;
        int n = preferences.getInt("rmt_debug_delay");
        int n2 = preferences.getInt("rmt_debug_poll_interval");
        long l = System.currentTimeMillis() + (long)n;
        boolean bl = true;
        do {
            try {
                virtualMachine = attachingConnector.attach(map);
                bl = false;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() > l) {
                    throw new IOException("Debugger launch time-out exceeded");
                }
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (bl);
        return virtualMachine;
    }

    private VirtualMachine waitForDebuggerConnection(ListeningConnector listeningConnector, Process process, IProcess iProcess, Map map, IProgressMonitor iProgressMonitor) throws CoreException, IOException, IllegalConnectorArgumentsException {
        VirtualMachine virtualMachine = null;
        boolean bl = false;
        while (true) {
            Object object;
            Thread thread;
            try {
                ConnectRunnable connectRunnable = new ConnectRunnable(listeningConnector, map);
                thread = new Thread((Runnable)connectRunnable, "Listening Connector");
                thread.start();
                while (thread.isAlive()) {
                    if (iProgressMonitor.isCanceled()) {
                        listeningConnector.stopListening(map);
                        process.destroy();
                        break;
                    }
                    try {
                        process.exitValue();
                        try {
                            listeningConnector.stopListening(map);
                        }
                        catch (IOException iOException) {}
                        this.checkErrorMessage(iProcess);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                object = connectRunnable.getException();
                if (object instanceof IllegalConnectorArgumentsException) {
                    throw (IllegalConnectorArgumentsException)object;
                }
                if (object instanceof InterruptedIOException) {
                    throw (InterruptedIOException)object;
                }
                if (object instanceof IOException) {
                    throw (IOException)object;
                }
                virtualMachine = connectRunnable.getVirtualMachine();
            }
            catch (InterruptedIOException interruptedIOException) {
                this.checkErrorMessage(iProcess);
                thread = new Status(4, "org.eclipse.mtj.core", 117, "", (Throwable)interruptedIOException);
                object = DebugPlugin.getDefault().getStatusHandler((IStatus)thread);
                bl = false;
                if (object == null) {
                    throw new CoreException((IStatus)thread);
                }
                Object object2 = object.handleStatus((IStatus)thread, (Object)this);
                if (!(object2 instanceof Boolean)) continue;
                bl = (Boolean)object2;
                if (bl) continue;
            }
            break;
        }
        return virtualMachine;
    }

    public void runWithoutDebug(VMRunnerConfiguration vMRunnerConfiguration, ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
        subProgressMonitor.beginTask(MTJCoreStrings.getString("debugvmrunner.launching_vm"), 3);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        subProgressMonitor.subTask(MTJCoreStrings.getString("debugvmrunner.constructing_cmd_line"));
        String[] stringArray = this.getCommandLine(iLaunchConfiguration, -1, iProgressMonitor);
        Utils.dumpCommandLine(stringArray);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        subProgressMonitor.worked(1);
        subProgressMonitor.subTask(MTJCoreStrings.getString("debugvmrunner.starting_VM"));
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        File file = this.getWorkingDir(vMRunnerConfiguration);
        Process process = this.exec(stringArray, file);
        if (process == null) {
            return;
        }
        if (iProgressMonitor.isCanceled()) {
            process.destroy();
            return;
        }
        IProcess iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)EmulatorRunner.renderProcessLabel(stringArray), (Map)this.getDefaultProcessMap());
        iProcess.setAttribute(IProcess.ATTR_CMDLINE, EmulatorRunner.renderCommandLine(stringArray));
        subProgressMonitor.worked(1);
    }

    protected String getPluginIdentifier() {
        return "org.eclipse.mtj.core";
    }

    protected void addArguments(String[] stringArray, List list) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
    }

    protected void checkErrorMessage(IProcess iProcess) throws CoreException {
        String string = iProcess.getStreamsProxy().getErrorStreamMonitor().getContents();
        if (string.length() == 0) {
            string = iProcess.getStreamsProxy().getOutputStreamMonitor().getContents();
        }
        if (string.length() != 0) {
            this.abort(string, null, 116);
        }
    }

    private AttachingConnector getAttachingConnector() {
        AttachingConnector attachingConnector = null;
        List<AttachingConnector> list = Bootstrap.virtualMachineManager().attachingConnectors();
        int n = 0;
        while (n < list.size()) {
            AttachingConnector attachingConnector2 = list.get(n);
            if ("com.sun.jdi.SocketAttach".equals(attachingConnector2.name())) {
                attachingConnector = attachingConnector2;
            }
            ++n;
        }
        return attachingConnector;
    }

    private ListeningConnector getListeningConnector() {
        ListeningConnector listeningConnector = null;
        List<ListeningConnector> list = Bootstrap.virtualMachineManager().listeningConnectors();
        int n = 0;
        while (n < list.size()) {
            ListeningConnector listeningConnector2 = list.get(n);
            if ("com.sun.jdi.SocketListen".equals(listeningConnector2.name())) {
                listeningConnector = listeningConnector2;
            }
            ++n;
        }
        return listeningConnector;
    }

    private File getWorkingDir(VMRunnerConfiguration vMRunnerConfiguration) throws CoreException {
        File file;
        File file2 = null;
        String string = null;
        if (this.device instanceof IDevice2 && (file = ((IDevice2)this.device).getWorkingDirectory()) != null && file.exists()) {
            string = file.getPath();
        }
        if (string == null) {
            string = vMRunnerConfiguration.getWorkingDirectory();
        }
        if (string != null && !(file2 = new File(string)).isDirectory()) {
            this.abort(MTJCoreStrings.getString("debugvmrunner.workingdir_not_dir", new String[]{string}), null, 108);
        }
        return file2;
    }

    private void specifyArguments(Map map, int n) {
        Connector.IntegerArgument integerArgument = (Connector.IntegerArgument)map.get("port");
        integerArgument.setValue(n);
        Connector.IntegerArgument integerArgument2 = (Connector.IntegerArgument)map.get("timeout");
        if (integerArgument2 != null) {
            int n2 = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            integerArgument2.setValue(n2);
        }
    }

    protected String[] getCommandLine(ILaunchConfiguration iLaunchConfiguration, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        LaunchEnvironment launchEnvironment = new LaunchEnvironment();
        launchEnvironment.setDebugLaunch(this.debugMode);
        launchEnvironment.setDebugListenerPort(n);
        launchEnvironment.setLaunchConfiguration(iLaunchConfiguration);
        launchEnvironment.setMidletSuite(this.suite);
        String string = this.device.getLaunchCommand(launchEnvironment, iProgressMonitor);
        ExecutionArguments executionArguments = new ExecutionArguments("", string);
        String[] stringArray = executionArguments.getProgramArgumentsArray();
        return stringArray;
    }

    public void run(VMRunnerConfiguration vMRunnerConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
    }

    static class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector listeningConnector, Map map) {
            this.fConnector = listeningConnector;
            this.fConnectionMap = map;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException iOException) {
                this.fException = iOException;
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                this.fException = illegalConnectorArgumentsException;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

