/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.packaging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.PreferenceAccessor;
import org.eclipse.mtj.core.internal.utils.TemporaryFileManager;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.internal.utils.tools.AbstractJavaTool;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;

public class ObfuscatorTool
extends AbstractJavaTool {
    private static final String TEMPLATE_NAME = "config.pro";
    private static final String PROGUARD_CFG_NAME = "proguard.cfg";
    private static final String NAME = "Obfuscator";
    private static final String MAIN_CLASS = "proguard.ProGuard";
    private static final String MAPPING_FILE_NAME = "pro_map.txt";
    private static final String SEEDS_FILE_NAME = "pro_seeds.txt";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private IMidletSuiteProject midletSuite;
    private File sourceJarFile;
    private File targetJarFile;
    private File deploymentDirectory;

    public ObfuscatorTool(IMidletSuiteProject iMidletSuiteProject, File file, File file2) {
        this.midletSuite = iMidletSuiteProject;
        this.sourceJarFile = file;
        this.targetJarFile = file2;
    }

    protected String[] getArguments() {
        String[] stringArray = null;
        try {
            File file = this.getProguardConfigFile();
            String string = "@" + file;
            stringArray = new String[]{string};
        }
        catch (Exception exception) {
            MTJCorePlugin.log(4, "getArguments", exception);
        }
        return stringArray;
    }

    protected String getClassName() {
        return MAIN_CLASS;
    }

    protected String[] getClasspath() {
        return new String[]{MTJCorePlugin.getProguardJarFile().toString()};
    }

    protected String getName() {
        return NAME;
    }

    protected String[] getVMArguments() {
        return EMPTY_STRING_ARRAY;
    }

    private File copyConfigFileIfNecessary(File file) throws IOException {
        File file2 = file;
        if (file.toString().indexOf(32) != -1) {
            file2 = TemporaryFileManager.instance.createTempFile("proguard_", ".cfg");
            Utils.copyFile(file, file2, null);
        }
        return file2;
    }

    private File getDeploymentDirectory() throws CoreException {
        if (this.deploymentDirectory == null) {
            String string = MTJCorePlugin.getDeploymentDirectoryName();
            this.deploymentDirectory = this.getMidletSuiteFile(string);
        }
        return this.deploymentDirectory;
    }

    private File getDeploymentDirectoryFile(String string) throws CoreException {
        return new File(this.getDeploymentDirectory(), string);
    }

    private String getLibraryJarsClasspath() throws CoreException {
        IDevice iDevice = this.midletSuite.getDevice();
        Classpath classpath = iDevice.getClasspath();
        return classpath.toString();
    }

    private File getProguardConfigFile() throws CoreException, IOException {
        File file = this.getDeploymentDirectoryFile(PROGUARD_CFG_NAME);
        this.writeConfigFileContents(file);
        file = this.copyConfigFileIfNecessary(file);
        return file;
    }

    private String getProguardConfigFileTemplate() throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        InputStream inputStream = this.getClass().getResourceAsStream(TEMPLATE_NAME);
        if (inputStream != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                    printWriter.flush();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        return stringWriter.toString();
    }

    private String getProguardKeepParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance;
        String[] stringArray = preferenceAccessor.getProguardKeepExpressions(this.midletSuite.getProject());
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringBuffer.append("-keep ").append(string).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private File getMidletSuiteFile(String string) throws CoreException {
        IProject iProject = this.midletSuite.getJavaProject().getProject();
        File file = iProject.getLocation().toFile();
        return new File(file, string);
    }

    private Object getProguardOptions() {
        IProject iProject = this.midletSuite.getProject();
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance;
        String string = preferenceAccessor.getSpecifiedProguardOptions(iProject);
        boolean bl = preferenceAccessor.isUseSpecifiedProguardOptions(iProject);
        return bl ? string : preferenceAccessor.getDefaultProguardOptions();
    }

    private String getQuotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(32) != -1) {
                stringBuffer.append("\"").append(string2).append("\"");
            } else {
                stringBuffer.append(string2);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(File.pathSeparatorChar);
        }
        return stringBuffer.toString();
    }

    private String getTemplateWithSubstitutions(String string) throws CoreException {
        File file = this.getDeploymentDirectoryFile(MAPPING_FILE_NAME);
        File file2 = this.getDeploymentDirectoryFile(SEEDS_FILE_NAME);
        Object[] objectArray = new Object[]{this.getQuotedString(this.getLibraryJarsClasspath()), this.getQuotedString(this.sourceJarFile.toString()), this.getQuotedString(this.targetJarFile.toString()), this.getQuotedString(file2.toString()), this.getQuotedString(file.toString()), this.getProguardOptions(), this.getProguardKeepParameters()};
        return MessageFormat.format(string, objectArray);
    }

    private void writeConfigFileContents(File file) throws IOException, CoreException {
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        String string = this.getProguardConfigFileTemplate();
        String string2 = this.getTemplateWithSubstitutions(string);
        printWriter.println(string2);
        printWriter.close();
    }
}

