/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preprocessor;

import antenna.preprocessor.v3.ILineFilter;
import antenna.preprocessor.v3.ILogger;
import antenna.preprocessor.v3.IPreprocessorListener;
import antenna.preprocessor.v3.Preprocessor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.BuildLoggingConfiguration;
import org.eclipse.mtj.core.console.BuildConsoleProxy;
import org.eclipse.mtj.core.hook.sourceMapper.SourceMapperAccess;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class PreprocessorBuilder
extends IncrementalProjectBuilder {
    public static final String PROBLEM_MARKER = "org.eclipse.mtj.core.preprocessor.problemmarker";
    public static final String PROCESSED_DIRECTORY = ".processed";
    private static final String PROCESSED_PATH = "/.processed";
    private BuildLoggingConfiguration buildLoggingConfig = BuildLoggingConfiguration.instance;
    private boolean checkedForHook = false;

    public static IFile getOutputFile(IResource iResource) {
        IPath iPath = new Path(PROCESSED_PATH).append(iResource.getProjectRelativePath());
        return iResource.getProject().getFile(iPath);
    }

    public static IProject getOutputProject(IProject iProject) {
        String string = "." + iProject.getName() + "_PP";
        return ResourcesPlugin.getWorkspace().getRoot().getProject(string);
    }

    public static boolean isPreprocessed(IResource iResource) {
        IPath iPath = iResource.getProjectRelativePath();
        return iPath.segment(0).equals(PROCESSED_DIRECTORY);
    }

    private void clearPreprocessorMarkers(IResource iResource) throws CoreException {
        IMarker[] iMarkerArray;
        IMarker[] iMarkerArray2 = iMarkerArray = iResource.findMarkers(PROBLEM_MARKER, true, 1);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray2[n2];
            iMarker.delete();
            ++n2;
        }
    }

    private void createParentFolders(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        IContainer iContainer;
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreprocessorBuilder.createParentFolders; resource = " + iResource);
        }
        if ((iContainer = iResource.getParent()).getType() == 2) {
            this.createParentFolders((IResource)iContainer, iProgressMonitor);
            IFolder iFolder = (IFolder)iContainer;
            if (!iFolder.exists()) {
                iFolder.create(true, true, iProgressMonitor);
                iFolder.setDerived(true);
            }
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreprocessorBuilder.createParentFolders");
        }
    }

    private void doPreprocessing(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        IResourceDelta iResourceDelta;
        IProject iProject = this.getProject();
        SymbolDefinitionSet symbolDefinitionSet = this.getProjectSymbolDefinitions(iProject);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreprocessorBuilder.doPreprocessing; project = " + iProject + "; symbols = " + (symbolDefinitionSet == null ? "none" : symbolDefinitionSet.getName()));
        }
        if ((iResourceDelta = this.getDelta(iProject)) == null) {
            ResourceVisitor resourceVisitor = new ResourceVisitor(symbolDefinitionSet, iProgressMonitor);
            iProject.accept((IResourceVisitor)resourceVisitor);
        } else {
            ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(symbolDefinitionSet, iProgressMonitor);
            iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreprocessorBuilder.doPreprocessing");
        }
    }

    private String getContentEncoding(IFile iFile) throws CoreException {
        String string = iFile.getContentDescription().getCharset();
        if (string == null) {
            string = System.getProperty("file.encoding", "UTF-8");
        }
        return string;
    }

    private IDocument getDocumentForFile(IFile iFile) throws CoreException {
        StringWriter stringWriter;
        block14: {
            String string = iFile.getCharset(true);
            InputStream inputStream = iFile.getContents();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            String string2 = null;
            stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                try {
                    while ((string2 = bufferedReader.readLine()) != null) {
                        printWriter.println(string2);
                    }
                }
                catch (IOException iOException) {
                    MTJCorePlugin.throwCoreException(4, -999, iOException);
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return new Document(stringWriter.toString());
    }

    private SymbolDefinitionSet getProjectSymbolDefinitions(IProject iProject) {
        SymbolDefinitionSet symbolDefinitionSet = null;
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(JavaCore.create((IProject)iProject));
        try {
            symbolDefinitionSet = iMidletSuiteProject.getEnabledSymbolDefinitionSet();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log(4, coreException);
        }
        catch (PersistenceException persistenceException) {
            MTJCorePlugin.log(4, persistenceException);
        }
        if (symbolDefinitionSet == null) {
            symbolDefinitionSet = new SymbolDefinitionSet("__default" + System.currentTimeMillis());
        }
        return symbolDefinitionSet;
    }

    private boolean isOnBuildPath(IResource iResource, IProgressMonitor iProgressMonitor) {
        IJavaElement iJavaElement;
        boolean bl = false;
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreprocessorBuilder.isOnBuildPath; resource = " + iResource);
        }
        if ((iJavaElement = JavaCore.create((IFile)((IFile)iResource))) != null) {
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
            bl = iPackageFragmentRoot.exists();
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreprocessorBuilder.isOnBuildPath; returning = " + bl);
        }
        return bl;
    }

    private void setReadOnly(IFile iFile, boolean bl) throws CoreException {
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        resourceAttributes.setReadOnly(bl);
        iFile.setResourceAttributes(resourceAttributes);
    }

    private boolean shouldBeProcessed(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        return iResource.getType() == 1 && iResource.getName().endsWith(".java") && !PreprocessorBuilder.isPreprocessed(iResource) && this.isOnBuildPath(iResource, iProgressMonitor);
    }

    private void writeProcessedResults(IResource iResource, byte[] byArray, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreprocessorBuilder.writeProcessedResults");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IFile iFile = PreprocessorBuilder.getOutputFile(iResource);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("- PreprocessorBuilder.writeProcessedResults; outputFile = " + iFile);
        }
        if (iFile.exists()) {
            if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                BuildConsoleProxy.instance.traceln("- PreprocessorBuilder.writeProcessedResults; outputFile exists, setting new contents");
            }
            this.setReadOnly(iFile, false);
            iFile.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
        } else {
            IContainer iContainer = iFile.getParent();
            if (!iContainer.exists()) {
                this.createParentFolders((IResource)iFile, iProgressMonitor);
            }
            iFile.create((InputStream)byteArrayInputStream, false, iProgressMonitor);
        }
        iFile.setCharset("UTF-8", iProgressMonitor);
        iFile.setDerived(true);
        this.setReadOnly(iFile, true);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreprocessorBuilder.writeProcessedResults");
        }
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("> PreprocessorBuilder.build");
        }
        if (!this.checkedForHook) {
            if (!SourceMapperAccess.isHookCodeInstalled()) {
                MTJCorePlugin.log(2, "Preprocessor invoked, but hook is not installed.  Consult the installation instructions for MTJ.");
            }
            this.checkedForHook = true;
        }
        this.doPreprocessing(n, iProgressMonitor);
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreprocessorBuilder.build");
        }
        return null;
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        IFolder iFolder = iProject.getFolder(PROCESSED_PATH);
        Utils.clearContainer((IContainer)iFolder, iProgressMonitor);
    }

    protected void createResourceMarker(IResource iResource, IDocument iDocument, String string, int n, int n2, int n3, boolean bl) {
        int n4 = bl ? 2 : 1;
        try {
            IMarker iMarker = iResource.createMarker(PROBLEM_MARKER);
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("severity", n4);
            int n5 = iDocument.getLineOffset(n) + n2;
            int n6 = n5 + n3;
            iMarker.setAttribute("charStart", n5);
            iMarker.setAttribute("charEnd", n6);
        }
        catch (Exception exception) {
            MTJCorePlugin.log(4, exception);
        }
    }

    protected void preprocess(final IResource iResource, SymbolDefinitionSet symbolDefinitionSet, IProgressMonitor iProgressMonitor) throws CoreException {
        block13: {
            if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                BuildConsoleProxy.instance.traceln("> PreprocessorBuilder.preprocess; resource = " + iResource);
                BuildConsoleProxy.instance.traceln("- PreprocessorBuilder.preprocess symbol set = " + symbolDefinitionSet.getName());
            }
            final IDocument iDocument = this.getDocumentForFile((IFile)iResource);
            this.clearPreprocessorMarkers(iResource);
            ILogger iLogger = new ILogger(){

                public void log(String string) {
                    if (PreprocessorBuilder.this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                        BuildConsoleProxy.instance.traceln(string);
                    }
                }
            };
            ILineFilter iLineFilter = new ILineFilter(){

                public String filter(String string) {
                    return string;
                }
            };
            IPreprocessorListener iPreprocessorListener = new IPreprocessorListener(){

                public void error(Exception exception, int n, int n2, int n3) {
                    if (PreprocessorBuilder.this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                        BuildConsoleProxy.instance.getConsoleWriter("error").println("Preprocessor error: " + exception);
                    }
                    PreprocessorBuilder.this.createResourceMarker(iResource, iDocument, exception.getMessage(), n, n2, n3, true);
                }

                public void warning(String string, int n, int n2, int n3) {
                    if (PreprocessorBuilder.this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
                        BuildConsoleProxy.instance.getConsoleWriter("output").println("Preprocessor warning: " + string);
                    }
                    PreprocessorBuilder.this.createResourceMarker(iResource, iDocument, string, n, n2, n3, false);
                }
            };
            IFile iFile = (IFile)iResource;
            File file = iFile.getLocation().toFile();
            String string = this.getContentEncoding(iFile);
            InputStream inputStream = iFile.getContents();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Preprocessor preprocessor = new Preprocessor(iLogger, iLineFilter);
            preprocessor.setFile(file);
            preprocessor.setListener(iPreprocessorListener);
            try {
                try {
                    preprocessor.addDefines(symbolDefinitionSet.toString());
                    preprocessor.preprocess(inputStream, (OutputStream)byteArrayOutputStream, string);
                    this.writeProcessedResults(iResource, byteArrayOutputStream.toByteArray(), iProgressMonitor);
                }
                catch (Exception exception) {
                    MTJCorePlugin.throwCoreException(4, -999, exception);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.buildLoggingConfig.isPreprocessorTraceEnabled()) {
            BuildConsoleProxy.instance.traceln("< PreprocessorBuilder.preprocess");
        }
    }

    private class ResourceDeltaVisitor
    extends ResourceVisitor
    implements IResourceDeltaVisitor {
        protected ResourceDeltaVisitor(SymbolDefinitionSet symbolDefinitionSet, IProgressMonitor iProgressMonitor) {
            super(symbolDefinitionSet, iProgressMonitor);
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            boolean bl = false;
            switch (iResourceDelta.getKind()) {
                case 1: 
                case 4: {
                    bl = this.visit(iResourceDelta.getResource());
                    break;
                }
                case 2: {
                    IFile iFile = PreprocessorBuilder.getOutputFile(iResourceDelta.getResource());
                    if (!iFile.exists()) break;
                    iFile.delete(true, this.monitor);
                }
            }
            return bl;
        }
    }

    protected class ResourceVisitor
    implements IResourceVisitor {
        protected SymbolDefinitionSet symbols;
        protected IProgressMonitor monitor;

        protected ResourceVisitor(SymbolDefinitionSet symbolDefinitionSet, IProgressMonitor iProgressMonitor) {
            this.symbols = symbolDefinitionSet;
            this.monitor = iProgressMonitor;
        }

        public boolean visit(IResource iResource) throws CoreException {
            if (PreprocessorBuilder.this.shouldBeProcessed(iResource, this.monitor)) {
                PreprocessorBuilder.this.preprocess(iResource, this.symbols, this.monitor);
            }
            return true;
        }
    }
}

