/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.PreferenceAccessor;
import org.eclipse.mtj.core.internal.tools.AntennaExportException;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.internal.utils.FilteringClasspathEntryVisitor;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntennaBuildExporter {
    private static final String NO_EXPORT = "_no_export";
    private static final String PATH_BUILD_CLASSES_NO_EXPORT = "${path.build.classes}/_no_export";
    private static final String PATH_BUILD_CLASSES = "${path.build.classes}";
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\@\\{(.+?)\\}");
    private IMidletSuiteProject midletSuite;
    private IJavaProject javaProject;
    private IPath basedirPath;
    private String projectName;
    private Properties buildProperties;
    private Document mtjBuildXmlDocument;

    public AntennaBuildExporter(IMidletSuiteProject iMidletSuiteProject) {
        this.midletSuite = iMidletSuiteProject;
        this.javaProject = iMidletSuiteProject.getJavaProject();
        this.basedirPath = this.javaProject.getProject().getLocation();
        this.projectName = iMidletSuiteProject.getProject().getName();
    }

    public void doExport(IProgressMonitor iProgressMonitor) throws CoreException, AntennaExportException {
        this.validateEnvironment(iProgressMonitor);
        try {
            this.buildProperties = this.createInitialProperties();
            this.mtjBuildXmlDocument = this.readMTJBuildTemplate();
            BuildClasspathEntryVisitor buildClasspathEntryVisitor = this.traverseClasspath(iProgressMonitor);
            this.updateMTJBuildXml(buildClasspathEntryVisitor.getProjectInfoMap());
            this.exportBuildXml(iProgressMonitor);
            this.writeBuildProperties(iProgressMonitor);
            this.writeMTJBuildXml(iProgressMonitor);
            this.javaProject.getProject().refreshLocal(1, iProgressMonitor);
        }
        catch (Exception exception) {
            if (exception instanceof CoreException) {
                throw (CoreException)((Object)exception);
            }
            MTJCorePlugin.throwCoreException(4, -999, exception);
        }
    }

    private Properties createInitialProperties() {
        Properties properties = new Properties();
        properties.setProperty("midlet.name", this.javaProject.getProject().getName());
        properties.setProperty("jad.name", this.midletSuite.getJadFileName());
        properties.setProperty("descriptor.name", this.midletSuite.getApplicationDescriptorFile().getName());
        properties.setProperty("path.build", "${basedir}/build");
        properties.setProperty("path.build.classes", "${basedir}/build/classes");
        properties.setProperty("path.build.output", "${basedir}/deployed");
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        properties.setProperty("wtk.home", preferences.getString("wtk_root"));
        properties.setProperty("path.antenna.jar", preferences.getString("antenna_jar"));
        boolean bl = PreferenceAccessor.instance.getAutoversionPackage(this.midletSuite.getProject());
        properties.setProperty("flag.autoversion", Boolean.toString(bl));
        properties.setProperty("flag.preverify", "true");
        properties.setProperty("src.encoding", "UTF-8");
        IDevice iDevice = this.midletSuite.getDevice();
        if (iDevice != null) {
            properties.setProperty("wtk.midpapi", iDevice.getClasspath().toString());
        }
        properties.setProperty("run.device.name", "DefaultColorPhone");
        properties.setProperty("run.trace.options", "");
        this.addObfuscationProperties(properties);
        this.addVersionProperties(properties);
        return properties;
    }

    private void addObfuscationProperties(Properties properties) {
        File file = MTJCorePlugin.getProguardJarFile();
        boolean bl = file != null && file.exists();
        properties.setProperty("flag.should.obfuscate", Boolean.toString(bl));
        if (bl) {
            File file2 = file.getParentFile().getParentFile();
            properties.setProperty("wtk.proguard.home", file2.toString());
        }
    }

    private void addVersionProperties(Properties properties) {
        int n;
        ApplicationDescriptor applicationDescriptor = this.midletSuite.getApplicationDescriptor();
        ColonDelimitedProperties colonDelimitedProperties = applicationDescriptor.getManifestProperties();
        String string = colonDelimitedProperties.getProperty("MicroEdition-Configuration");
        if (string != null) {
            n = string.indexOf(45);
            string = n == -1 ? string : string.substring(n + 1);
            properties.setProperty("wtk.cldc.version", string);
        }
        if ((string = colonDelimitedProperties.getProperty("MicroEdition-Profile")) != null) {
            n = string.indexOf(45);
            string = n == -1 ? string : string.substring(n + 1);
            properties.setProperty("wtk.midp.version", string);
        }
    }

    private void addWtkObfuscateArgument(Element element, String string) {
        Element element2 = this.newChildElement(element, "argument");
        element2.setAttribute("value", string);
    }

    private StringBuffer readBuildXmlTemplate(InputStream inputStream) throws UnsupportedEncodingException, IOException {
        int n;
        char[] cArray = new char[1024];
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        inputStream.close();
        return stringBuffer;
    }

    private Document readMTJBuildTemplate() throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        InputStream inputStream = this.getClass().getResourceAsStream("mtj-build.xml");
        if (inputStream == null) {
            throw new IOException("build.xml template not found");
        }
        document = XMLUtils.readDocument(inputStream);
        Element element = document.getDocumentElement();
        element.setAttribute("name", "mtj-" + this.projectName);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tAutomatically generated by MTJ on ").append(new Date()).append("\n\tDO NOT ALTER THIS FILE.  IT WILL BE OVERWRITTEN\n\n").append("\tChanges may be made to build.xml and user-build.properties\n");
        this.insertCommentBefore(element, stringBuffer.toString());
        return document;
    }

    private void replaceTemplateValues(StringBuffer stringBuffer, Properties properties) {
        int n = 0;
        Matcher matcher = SUBSTITUTION_PATTERN.matcher(stringBuffer);
        while (matcher.find(n)) {
            String string = matcher.group(1);
            String string2 = properties.getProperty(string, string);
            stringBuffer.replace(matcher.start(), matcher.end(), string2);
            n = matcher.start() + string2.length();
        }
    }

    private void exportBuildXml(IProgressMonitor iProgressMonitor) throws ParserConfigurationException, SAXException, TransformerException, IOException, CoreException {
        File file = this.getMidletSuiteFile("build.xml", iProgressMonitor);
        if (!file.exists()) {
            Properties properties = new Properties();
            properties.setProperty("mtj.version", MTJCorePlugin.getPluginVersion());
            properties.setProperty("date", new Date().toString());
            properties.setProperty("project.name", this.projectName);
            InputStream inputStream = this.getClass().getResourceAsStream("buildtemplate.xml");
            if (inputStream != null) {
                StringBuffer stringBuffer = this.readBuildXmlTemplate(inputStream);
                this.replaceTemplateValues(stringBuffer, properties);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(stringBuffer.toString());
                outputStreamWriter.close();
            }
        }
    }

    private Element findElement(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    private File getMidletSuiteFile(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile = this.midletSuite.getProject().getFile(string);
        return iFile.getLocation().toFile();
    }

    private String getProguardOptions() {
        IProject iProject = this.midletSuite.getProject();
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance;
        String string = preferenceAccessor.getSpecifiedProguardOptions(iProject);
        boolean bl = preferenceAccessor.isUseSpecifiedProguardOptions(iProject);
        return bl ? string : preferenceAccessor.getDefaultProguardOptions();
    }

    private String getRelativePath(IPath iPath, IPath iPath2) {
        boolean bl;
        String string = null;
        int n = iPath2.matchingFirstSegments(iPath);
        String string2 = iPath.getDevice();
        String string3 = iPath2.getDevice();
        boolean bl2 = bl = string2 == null && string3 == null;
        if (bl || string2.equals(string3)) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.basedirPath.segmentCount() - n;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("/..");
                ++n3;
            }
            iPath2 = iPath2.removeFirstSegments(n);
            String[] stringArray = iPath2.segments();
            int n4 = 0;
            while (n4 < stringArray.length) {
                stringBuffer.append("/").append(stringArray[n4]);
                ++n4;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private File getWTKRoot() {
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        return new File(preferences.getString("wtk_root"));
    }

    private void insertCommentBefore(Element element, String string) {
        Document document = element.getOwnerDocument();
        Comment comment = document.createComment(string);
        document.insertBefore(comment, element);
    }

    private Element newChildElement(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element.appendChild(element2);
        return element2;
    }

    private BuildClasspathEntryVisitor traverseClasspath(IProgressMonitor iProgressMonitor) throws CoreException {
        BuildClasspathEntryVisitor buildClasspathEntryVisitor = new BuildClasspathEntryVisitor(this.javaProject);
        buildClasspathEntryVisitor.getRunner(true).run(this.javaProject, buildClasspathEntryVisitor, iProgressMonitor);
        return buildClasspathEntryVisitor;
    }

    private void updateMTJBuildXml(Map<IJavaProject, ProjectInfo> map) {
        Map.Entry<IJavaProject, ProjectInfo> entry2;
        Document document = this.mtjBuildXmlDocument;
        Element element = document.getDocumentElement();
        Element element2 = this.findElement(element, "path");
        Element element3 = this.findElement(element, "wtkbuild");
        Element element4 = this.findElement(element, "wtkpackage");
        Element element5 = element3;
        for (Map.Entry<IJavaProject, ProjectInfo> entry2 : map.entrySet()) {
            Element element6;
            ProjectInfo projectInfo = entry2.getValue();
            String string = projectInfo.getAntProjectPropertyValue();
            string = string.length() == 0 ? "${basedir}" : "${basedir}" + string;
            this.buildProperties.setProperty(projectInfo.getAntProjectPropertyName(), string);
            element2.getParentNode().insertBefore(projectInfo.getClasspathElement(), element2);
            Iterator<Element> iterator = projectInfo.getWtkBuildElements();
            while (iterator.hasNext()) {
                element6 = iterator.next();
                element3.getParentNode().insertBefore(element6, element5);
                element5 = element6;
            }
            if (!projectInfo.isExported()) continue;
            element6 = this.newChildElement(element4, "classpath");
            element6.setAttribute("refid", projectInfo.getClasspathElementId());
            for (Element element7 : projectInfo.getPackageFilesetElements()) {
                element4.appendChild(element7);
            }
        }
        element2.getParentNode().removeChild(element2);
        element3.getParentNode().removeChild(element3);
        entry2 = this.findElement(element, "wtkobfuscate");
        this.updateWtkObfuscateElement((Element)((Object)entry2));
    }

    private void updateWtkObfuscateElement(Element element) {
        String[] stringArray = PreferenceAccessor.instance.getProguardKeepExpressions(this.midletSuite.getProject());
        int n = 0;
        while (n < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer("'-keep ");
            stringBuffer.append(stringArray[n]).append("'");
            this.addWtkObfuscateArgument(element, stringBuffer.toString());
            ++n;
        }
        this.addWtkObfuscateArgument(element, this.getProguardOptions());
    }

    private void validateAntenna(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        boolean bl = false;
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        String string = preferences.getString("antenna_jar");
        File file = new File(string);
        if (file.exists()) {
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry("antenna.properties");
                bl = zipEntry != null;
                zipFile.close();
            }
            catch (IOException iOException) {
                MTJCorePlugin.log(2, "Error testing Antenna settings", iOException);
            }
        }
        if (!bl) {
            throw new AntennaExportException("Antenna library not found or not valid.\nCheck the preference settings.");
        }
    }

    private void validateEnvironment(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        this.validateAntenna(iProgressMonitor);
        this.validateWTK(iProgressMonitor);
    }

    private void validateWTK(IProgressMonitor iProgressMonitor) throws AntennaExportException {
        File file = this.getWTKRoot();
        if (file == null || !file.exists()) {
            throw new AntennaExportException("Sun WTK not found.\nCheck the platform definition settings.");
        }
    }

    private void writeBuildProperties(IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        File file = this.getMidletSuiteFile("mtj-build.properties", iProgressMonitor);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.buildProperties.store(fileOutputStream, " MTJ Build Properties - DO NOT ALTER THIS FILE - Make changes in user-build.properties");
        fileOutputStream.close();
    }

    private void writeMTJBuildXml(IProgressMonitor iProgressMonitor) throws TransformerException, IOException, CoreException {
        File file = this.getMidletSuiteFile("mtj-build.xml", iProgressMonitor);
        XMLUtils.writeDocument(file, this.mtjBuildXmlDocument);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildClasspathEntryVisitor
    extends FilteringClasspathEntryVisitor {
        private Map<IJavaProject, ProjectInfo> projectInfoMap = new LinkedHashMap<IJavaProject, ProjectInfo>();

        public BuildClasspathEntryVisitor(IJavaProject iJavaProject) {
            this.createProjectInfo(iJavaProject, true);
        }

        public Map<IJavaProject, ProjectInfo> getProjectInfoMap() {
            return this.projectInfoMap;
        }

        @Override
        public void visitLibraryEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            ProjectInfo projectInfo = this.getProjectInfo(iJavaProject);
            Element element = projectInfo.getClasspathElement();
            IPath iPath = this.getLibraryLocation(iClasspathEntry);
            if (iPath != null) {
                File file = iPath.toFile();
                Element element2 = AntennaBuildExporter.this.newChildElement(element, "path");
                String string = this.getProjectRelativeValue(iJavaProject, projectInfo, iPath);
                element2.setAttribute("location", string);
                this.addIncludesAndExcludes(iClasspathEntry, element2);
                if (this.isLibraryExported(iClasspathEntry)) {
                    if (file.isDirectory()) {
                        Element element3 = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement("fileset");
                        projectInfo.addPackageFilesetElement(element3);
                        element3.setAttribute("dir", string);
                    } else {
                        Element element4 = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement("zipfileset");
                        projectInfo.addPackageFilesetElement(element4);
                        element4.setAttribute("src", string);
                        this.addIncludesAndExcludes(iClasspathEntry, element4);
                    }
                }
            }
        }

        @Override
        public boolean visitProject(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IJavaProject iJavaProject2, IProgressMonitor iProgressMonitor) throws CoreException {
            boolean bl = iClasspathEntry.isExported();
            this.createProjectInfo(iJavaProject2, bl);
            return super.visitProject(iClasspathEntry, iJavaProject, iJavaProject2, iProgressMonitor);
        }

        @Override
        public void visitSourceEntry(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
            IPath iPath = this.getSourceLocation(iClasspathEntry);
            if (iPath != null) {
                ProjectInfo projectInfo = this.getProjectInfo(iJavaProject);
                String string = projectInfo.isExported() ? "wtkbuild" : "javac";
                Element element = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement(string);
                projectInfo.addWtkBuildElement(iClasspathEntry, element);
                element.setAttribute("destdir", projectInfo.getBuildDestination());
                element.setAttribute("sourcepath", "");
                element.setAttribute("encoding", "${src.encoding}");
                element.setAttribute("source", "1.3");
                String string2 = this.getProjectRelativeValue(iJavaProject, projectInfo, iPath);
                element.setAttribute("srcdir", string2);
                this.addIncludesAndExcludes(iClasspathEntry, element);
                Element element2 = AntennaBuildExporter.this.newChildElement(element, "classpath");
                element2.setAttribute("refid", projectInfo.getClasspathElementId());
                Element element3 = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement("fileset");
                element3.setAttribute("dir", string2);
                Element element4 = AntennaBuildExporter.this.newChildElement(element3, "exclude");
                element4.setAttribute("name", "**/*.java");
                Element element5 = AntennaBuildExporter.this.newChildElement(element3, "exclude");
                element5.setAttribute("name", "build/");
                this.addIncludesAndExcludes(iClasspathEntry, element3);
                projectInfo.addPackageFilesetElement(element3);
            } else {
                MTJCorePlugin.log(2, "Skipping unresolvable classpath entry " + iClasspathEntry);
            }
        }

        private void addIncludesAndExcludes(IClasspathEntry iClasspathEntry, Element element) {
            Element element2;
            IPath iPath;
            int n = 0;
            while (n < iClasspathEntry.getExclusionPatterns().length) {
                iPath = iClasspathEntry.getExclusionPatterns()[n];
                element2 = AntennaBuildExporter.this.newChildElement(element, "exclude");
                element2.setAttribute("name", iPath.toString());
                ++n;
            }
            n = 0;
            while (n < iClasspathEntry.getInclusionPatterns().length) {
                iPath = iClasspathEntry.getInclusionPatterns()[n];
                element2 = AntennaBuildExporter.this.newChildElement(element, "include");
                element2.setAttribute("name", iPath.toString());
                ++n;
            }
        }

        private void createProjectInfo(IJavaProject iJavaProject, boolean bl) {
            ProjectInfo projectInfo = new ProjectInfo(iJavaProject, bl);
            this.projectInfoMap.put(iJavaProject, projectInfo);
        }

        private ProjectInfo getProjectInfo(IJavaProject iJavaProject) {
            return this.projectInfoMap.get(iJavaProject);
        }

        private IPath getLibraryLocation(IClasspathEntry iClasspathEntry) throws CoreException {
            IPath iPath = null;
            Object object = Utils.getResolvedClasspathEntry(iClasspathEntry);
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                iPath = iResource.getLocation();
            } else if (object instanceof File) {
                iPath = iClasspathEntry.getPath();
            }
            return iPath;
        }

        private String getProjectRelativeValue(IJavaProject iJavaProject, ProjectInfo projectInfo, IPath iPath) throws CoreException {
            StringBuffer stringBuffer = new StringBuffer();
            IPath iPath2 = iJavaProject.getProject().getLocation();
            String string = AntennaBuildExporter.this.getRelativePath(iPath2, iPath);
            if (string == null) {
                stringBuffer.append(iPath.toString());
            } else {
                stringBuffer.append("${").append(projectInfo.getAntProjectPropertyName()).append("}").append(string);
            }
            return stringBuffer.toString();
        }

        private IPath getSourceLocation(IClasspathEntry iClasspathEntry) throws CoreException {
            IPath iPath = null;
            Object object = Utils.getResolvedClasspathEntry(iClasspathEntry);
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                iPath = iResource.getLocation();
            }
            return iPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectInfo {
        private String safeProjectName;
        private IJavaProject javaProject;
        private boolean exported;
        private Element classpathElement;
        private Map<IClasspathEntry, Element> wtkBuildElements;
        private List<Element> packageFilesetElements;

        ProjectInfo(IJavaProject iJavaProject, boolean bl) {
            this.javaProject = iJavaProject;
            this.exported = bl;
            this.wtkBuildElements = new HashMap<IClasspathEntry, Element>();
            this.packageFilesetElements = new ArrayList<Element>();
            this.safeProjectName = iJavaProject.getElementName();
            this.safeProjectName = this.safeProjectName.replace(' ', '_');
        }

        public void addPackageFilesetElement(Element element) {
            this.packageFilesetElements.add(element);
        }

        public void addWtkBuildElement(IClasspathEntry iClasspathEntry, Element element) {
            if (!this.wtkBuildElements.containsKey(iClasspathEntry)) {
                this.wtkBuildElements.put(iClasspathEntry, element);
            }
        }

        public String getAntProjectPropertyName() {
            return "project.root." + this.safeProjectName;
        }

        public String getAntProjectPropertyValue() {
            String string = null;
            IPath iPath = this.javaProject.getProject().getLocation();
            string = AntennaBuildExporter.this.getRelativePath(AntennaBuildExporter.this.basedirPath, iPath);
            if (string == null) {
                string = iPath.toString();
            }
            return string;
        }

        public String getBuildDestination() {
            return this.exported ? AntennaBuildExporter.PATH_BUILD_CLASSES : AntennaBuildExporter.PATH_BUILD_CLASSES_NO_EXPORT;
        }

        public Element getClasspathElement() {
            if (this.classpathElement == null) {
                this.classpathElement = AntennaBuildExporter.this.mtjBuildXmlDocument.createElement("path");
                this.classpathElement.setAttribute("id", this.getClasspathElementId());
                Element element = AntennaBuildExporter.this.newChildElement(this.classpathElement, "path");
                element.setAttribute("location", AntennaBuildExporter.PATH_BUILD_CLASSES);
                element = AntennaBuildExporter.this.newChildElement(this.classpathElement, "path");
                element.setAttribute("location", AntennaBuildExporter.PATH_BUILD_CLASSES_NO_EXPORT);
            }
            return this.classpathElement;
        }

        public String getClasspathElementId() {
            return "classpath." + this.safeProjectName;
        }

        public List<Element> getPackageFilesetElements() {
            return this.packageFilesetElements;
        }

        public Iterator<Element> getWtkBuildElements() {
            return this.wtkBuildElements.values().iterator();
        }

        public boolean isExported() {
            return this.exported;
        }
    }
}

