/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class EnvironmentVariables {
    private Properties variables = new Properties();
    private Map<String, String> nameMap = new HashMap<String, String>();

    public EnvironmentVariables() throws IOException {
        this.retrieveEnvironmentVariables();
    }

    public boolean containsVariable(String string) {
        return this.getVariable(string) != null;
    }

    public String[] convertToStrings() {
        String[] stringArray = new String[this.variables.size()];
        int n = 0;
        for (Map.Entry<Object, Object> entry : this.variables.entrySet()) {
            stringArray[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return stringArray;
    }

    public String getVariable(String string) {
        String string2 = this.nameMap.get(string.toUpperCase());
        return string2 == null ? null : (String)this.variables.get(string2);
    }

    public void setVariable(String string, String string2) {
        String string3 = this.nameMap.get(string.toUpperCase());
        if (string3 == null) {
            string3 = string;
            this.nameMap.put(string3, string3);
        }
        this.variables.setProperty(string3, string2);
    }

    private void retrieveEnvironmentVariables() throws IOException {
        String string = this.getEnvironmentVariablesCommand();
        Process process = Runtime.getRuntime().exec(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(61);
                if (n == -1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                this.variables.setProperty(string3, string4);
                this.nameMap.put(string3.toUpperCase(), string3);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    private String getEnvironmentVariablesCommand() {
        String string = null;
        string = Platform.getOS().equals("win32") ? "cmd.exe /c set" : "env";
        return string;
    }
}

