/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.utils;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.mtj.core.internal.utils.AbstractSearchScope;

public class MidletSearchScope
extends AbstractSearchScope {
    private IJavaSearchScope[] scopes;

    public MidletSearchScope(IJavaProject iJavaProject) throws JavaModelException {
        this.scopes = this.createSearchScopes(iJavaProject);
    }

    public boolean encloses(String string) {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.scopes.length) {
            bl = this.scopes[n].encloses(string);
            ++n;
        }
        return bl;
    }

    public boolean encloses(IJavaElement iJavaElement) {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.scopes.length) {
            bl = this.scopes[n].encloses(iJavaElement);
            ++n;
        }
        return bl;
    }

    public IPath[] enclosingProjectsAndJars() {
        HashSet<IPath> hashSet = new HashSet<IPath>();
        int n = 0;
        while (n < this.scopes.length) {
            IJavaSearchScope iJavaSearchScope = this.scopes[n];
            IPath[] iPathArray = iJavaSearchScope.enclosingProjectsAndJars();
            int n2 = 0;
            while (n2 < iPathArray.length) {
                hashSet.add(iPathArray[n2]);
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new IPath[hashSet.size()]);
    }

    private IJavaSearchScope[] createSearchScopes(IJavaProject iJavaProject) throws JavaModelException {
        IJavaSearchScope[] iJavaSearchScopeArray = null;
        if (iJavaProject == null || !iJavaProject.exists()) {
            IJavaSearchScope iJavaSearchScope = SearchEngine.createWorkspaceScope();
            iJavaSearchScopeArray = new IJavaSearchScope[]{iJavaSearchScope};
        } else {
            IType iType = iJavaProject.findType("javax.microedition.midlet.MIDlet");
            IJavaElement[] iJavaElementArray = new IJavaElement[]{iJavaProject};
            iJavaSearchScopeArray = new IJavaSearchScope[]{SearchEngine.createHierarchyScope((IType)iType), SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray), new MidletSuperclassExclusionScope()};
        }
        return iJavaSearchScopeArray;
    }

    private static class MidletSuperclassExclusionScope
    extends AbstractSearchScope {
        private MidletSuperclassExclusionScope() {
        }

        public boolean encloses(String string) {
            boolean bl = string.endsWith("java/lang/Object.class") || string.endsWith("javax/microedition/midlet/MIDlet.class");
            return !bl;
        }

        public boolean encloses(IJavaElement iJavaElement) {
            return true;
        }

        public IPath[] enclosingProjectsAndJars() {
            return new IPath[0];
        }
    }
}

