/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model;

import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Object> {
    private String major;
    private String minor;
    private String secondary;
    private String patch;
    private String versionString;

    public Version(String string) {
        this.versionString = string;
        this.major = "";
        this.minor = "";
        this.secondary = "";
        this.patch = "";
        this.parseVersionString(string);
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Version)object);
    }

    @Override
    public int compareTo(Version version) {
        int n = this.major.compareTo(version.major);
        if (n != 0) {
            return n;
        }
        n = this.minor.compareTo(version.minor);
        if (n != 0) {
            return n;
        }
        n = this.secondary.compareTo(version.secondary);
        if (n != 0) {
            return n;
        }
        n = this.patch.compareTo(version.patch);
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof Version && this.equals((Version)object);
    }

    public boolean equals(Version version) {
        return this.compareTo(version) == 0;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public String toString() {
        return this.versionString;
    }

    private void parseVersionString(String string) {
        StringTokenizer stringTokenizer;
        int n = string.indexOf(95);
        if (n != -1) {
            this.patch = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if ((stringTokenizer = new StringTokenizer(string, ".")).hasMoreTokens()) {
            this.major = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.minor = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.secondary = stringTokenizer.nextToken();
        }
    }
}

