/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.device;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceRegistry
implements IPersistable {
    public static final DeviceRegistry singleton = new DeviceRegistry();
    private static final String FILENAME = "devices.xml";
    private Map<String, Map<String, IDevice>> deviceGroupsMap;
    private ArrayList<IDeviceRegistryListener> listenerList = new ArrayList();
    private IDevice defaultDevice;

    private DeviceRegistry() {
    }

    public void addDevice(IDevice iDevice, boolean bl) throws IllegalArgumentException, PersistenceException {
        if (iDevice.getGroupName() == null || iDevice.getName() == null) {
            throw new IllegalArgumentException();
        }
        Map<String, IDevice> map = this.getDeviceGroupMap(iDevice.getGroupName(), true);
        map.put(iDevice.getName(), iDevice);
        if (bl) {
            this.fireDeviceAddedEvent(iDevice);
        }
    }

    public void addRegistryListener(IDeviceRegistryListener iDeviceRegistryListener) {
        this.listenerList.add(iDeviceRegistryListener);
    }

    public void clear() throws PersistenceException {
        this.getDeviceGroupsMap().clear();
    }

    public List<IDevice> getAllDevices() throws PersistenceException {
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        for (Map<String, IDevice> map : this.getDeviceGroupsMap().values()) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public IDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    public IDevice getDevice(String string, String string2) throws PersistenceException {
        IDevice iDevice = null;
        Map<String, IDevice> map = this.getDeviceGroupMap(string, false);
        if (map != null) {
            iDevice = map.get(string2);
        }
        return iDevice;
    }

    public int getDeviceCount() throws PersistenceException {
        int n = 0;
        for (Map<String, IDevice> map : this.getDeviceGroupsMap().values()) {
            n += map.size();
        }
        return n;
    }

    public List<String> getDeviceGroups() throws PersistenceException {
        return new ArrayList<String>((Collection)this.getDeviceGroupsMap().keySet());
    }

    public List<IDevice> getDevices(String string) throws PersistenceException {
        ArrayList<IDevice> arrayList = null;
        Map<String, IDevice> map = this.getDeviceGroupMap(string, false);
        if (map != null) {
            arrayList = new ArrayList<IDevice>(map.values());
        }
        return arrayList;
    }

    public void load() throws PersistenceException {
        File file = this.getComponentStoreFile();
        if (file.exists()) {
            try {
                Document document = XMLUtils.readDocument(file);
                XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider(document);
                this.loadUsing(xMLPersistenceProvider);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new PersistenceException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.getDeviceGroupsMap().clear();
        int n = iPersistenceProvider.loadInteger("deviceCount");
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = (IDevice)iPersistenceProvider.loadPersistable("device" + n2);
            this.addDevice(iDevice, false);
            ++n2;
        }
        this.defaultDevice = (IDevice)iPersistenceProvider.loadReference("defaultDevice");
    }

    public void removeDevice(IDevice iDevice) throws PersistenceException {
        Map<String, IDevice> map = this.getDeviceGroupMap(iDevice.getGroupName(), false);
        if (map != null) {
            map.remove(iDevice.getName());
            if (map.isEmpty()) {
                this.deviceGroupsMap.remove(iDevice.getGroupName());
            }
            if (iDevice.equals(this.defaultDevice)) {
                this.defaultDevice = null;
            }
        }
        this.fireDeviceRemovedEvent(iDevice);
    }

    public void removeRegistryListener(IDeviceRegistryListener iDeviceRegistryListener) {
        this.listenerList.remove(iDeviceRegistryListener);
    }

    public void setDefaultDevice(IDevice iDevice) {
        this.defaultDevice = iDevice;
    }

    public void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider("deviceRegistry");
        this.storeUsing(xMLPersistenceProvider);
        XMLUtils.writeDocument(this.getComponentStoreFile(), xMLPersistenceProvider.getDocument());
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        List<IDevice> list = this.getAllDevices();
        iPersistenceProvider.storeInteger("deviceCount", list.size());
        int n = 0;
        for (IDevice iDevice : list) {
            iPersistenceProvider.storePersistable("device" + n++, iDevice);
        }
        if (this.defaultDevice != null) {
            iPersistenceProvider.storeReference("defaultDevice", this.defaultDevice);
        }
    }

    private void createAndLoadDeviceGroups() throws PersistenceException {
        this.deviceGroupsMap = new HashMap<String, Map<String, IDevice>>();
        this.load();
    }

    private void fireDeviceAddedEvent(IDevice iDevice) {
        for (IDeviceRegistryListener iDeviceRegistryListener : this.listenerList) {
            iDeviceRegistryListener.deviceAdded(iDevice);
        }
    }

    private void fireDeviceRemovedEvent(IDevice iDevice) {
        for (IDeviceRegistryListener iDeviceRegistryListener : this.listenerList) {
            iDeviceRegistryListener.deviceRemoved(iDevice);
        }
    }

    private File getComponentStoreFile() {
        IPath iPath = MTJCorePlugin.getDefault().getStateLocation();
        IPath iPath2 = iPath.append(FILENAME);
        return iPath2.toFile();
    }

    private Map<String, IDevice> getDeviceGroupMap(String string, boolean bl) throws PersistenceException {
        Map<String, Map<String, IDevice>> map = this.getDeviceGroupsMap();
        Map<String, IDevice> map2 = map.get(string);
        if (map2 == null && bl) {
            map2 = new HashMap<String, IDevice>();
            map.put(string, map2);
        }
        return map2;
    }

    private synchronized Map<String, Map<String, IDevice>> getDeviceGroupsMap() throws PersistenceException {
        if (this.deviceGroupsMap == null) {
            this.createAndLoadDeviceGroups();
        }
        return this.deviceGroupsMap;
    }
}

