/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.device.impl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.LaunchingUtils;
import org.eclipse.mtj.core.internal.overtheair.OTAServer;
import org.eclipse.mtj.core.internal.preverification.builder.PreverificationBuilder;
import org.eclipse.mtj.core.internal.utils.TemporaryFileManager;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.APIType;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.persistence.IBundleReferencePersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDevice
implements IDevice,
IBundleReferencePersistable {
    protected String bundle;
    protected Classpath classpath;
    protected boolean debugServer;
    protected String description;
    protected Properties deviceProperties;
    protected File executable;
    protected String name;
    protected String[] protectionDomains;
    protected String groupName;
    protected IPreverifier preverifier;
    protected String launchCommandTemplate;

    public boolean equals(AbstractDevice abstractDevice) {
        return this.classpath.equals(abstractDevice.classpath) && this.executable.equals(abstractDevice.executable) && this.name.equals(abstractDevice.name) && this.groupName.equals(abstractDevice.groupName);
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public Classpath getClasspath() {
        return this.classpath;
    }

    @Override
    public ILibrary getConfigurationLibrary() {
        return this.getLibraryWithType(APIType.CONFIGURATION);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Properties getDeviceProperties() {
        return this.deviceProperties;
    }

    public File getExecutable() {
        return this.executable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPreverifier getPreverifier() {
        return this.preverifier;
    }

    @Override
    public ILibrary getProfileLibrary() {
        return this.getLibraryWithType(APIType.PROFILE);
    }

    @Override
    public String[] getProtectionDomains() {
        return this.protectionDomains;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean isDebugServer() {
        return this.debugServer;
    }

    @Override
    public boolean isPredeploymentRequired() {
        return false;
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        this.classpath = (Classpath)iPersistenceProvider.loadPersistable("classpath");
        this.debugServer = iPersistenceProvider.loadBoolean("debugServer");
        this.description = iPersistenceProvider.loadString("description");
        this.deviceProperties = iPersistenceProvider.loadProperties("deviceProperties");
        this.name = iPersistenceProvider.loadString("name");
        this.protectionDomains = new String[iPersistenceProvider.loadInteger("protectionDomainsCount")];
        int n = 0;
        while (n < this.protectionDomains.length) {
            this.protectionDomains[n] = iPersistenceProvider.loadString("protectionDomain" + n).trim();
            ++n;
        }
        this.groupName = iPersistenceProvider.loadString("groupName");
        this.preverifier = (IPreverifier)iPersistenceProvider.loadPersistable("preverifier");
        this.launchCommandTemplate = iPersistenceProvider.loadString("rawLaunchCommand");
        String string = iPersistenceProvider.loadString("executable");
        if (string != null && string.trim().length() > 0) {
            this.executable = new File(string);
        }
    }

    public void setClasspath(Classpath classpath) {
        this.classpath = classpath;
    }

    public void setDebugServer(boolean bl) {
        this.debugServer = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDeviceProperties(Properties properties) {
        this.deviceProperties = properties;
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setPredeploymentRequired(boolean bl) {
    }

    public void setPreverifier(IPreverifier iPreverifier) {
        this.preverifier = iPreverifier;
    }

    public void setProtectionDomains(String[] stringArray) {
        this.protectionDomains = stringArray;
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim();
            ++n;
        }
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        iPersistenceProvider.storePersistable("classpath", this.classpath);
        iPersistenceProvider.storeBoolean("debugServer", this.debugServer);
        iPersistenceProvider.storeString("description", this.description);
        iPersistenceProvider.storeProperties("deviceProperties", this.deviceProperties);
        iPersistenceProvider.storeString("name", this.name);
        iPersistenceProvider.storeInteger("protectionDomainsCount", this.protectionDomains.length);
        int n = 0;
        while (n < this.protectionDomains.length) {
            iPersistenceProvider.storeString("protectionDomain" + n, this.protectionDomains[n]);
            ++n;
        }
        iPersistenceProvider.storeString("groupName", this.groupName);
        iPersistenceProvider.storePersistable("preverifier", this.preverifier);
        iPersistenceProvider.storeString("rawLaunchCommand", this.launchCommandTemplate);
        if (this.executable != null) {
            iPersistenceProvider.storeString("executable", this.executable.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getGroupName());
        stringBuffer.append("/").append(this.getName());
        return stringBuffer.toString();
    }

    @Override
    public void setBundle(String string) {
        this.bundle = string;
    }

    public String getLaunchCommandTemplate() {
        return this.launchCommandTemplate;
    }

    public void setLaunchCommandTemplate(String string) {
        this.launchCommandTemplate = string;
    }

    protected void addLaunchConfigurationValue(Map<String, String> map, String string, ILaunchConfiguration iLaunchConfiguration, String string2) throws CoreException {
        String string3 = iLaunchConfiguration.getAttribute(string2, null);
        if (string3 != null) {
            map.put(string, string3);
        }
    }

    protected File copyForLaunch(IMidletSuiteProject iMidletSuiteProject, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        try {
            if (bl) {
                IFolder iFolder = LaunchingUtils.getEmulationFolder(iMidletSuiteProject);
                File file = LaunchingUtils.makeJadLaunchBaseDir(iMidletSuiteProject);
                File file2 = iFolder.getFile(iMidletSuiteProject.getJadFileName()).getLocation().toFile();
                File file3 = iFolder.getFile(iMidletSuiteProject.getJarFilename()).getLocation().toFile();
                File file4 = new File(file, iMidletSuiteProject.getJadFileName());
                File file5 = new File(file, iMidletSuiteProject.getJarFilename());
                Utils.copyFile(file2, file4, null);
                Utils.copyFile(file3, file5, null);
                LaunchingUtils.getProjectTempFolder(iMidletSuiteProject).refreshLocal(2, iProgressMonitor);
                return file;
            }
            File file = null;
            IFolder iFolder = LaunchingUtils.getEmulationFolder(iMidletSuiteProject);
            File file6 = iFolder.getLocation().toFile();
            String string = iMidletSuiteProject.getProject().getName().replace(' ', '_');
            file = TemporaryFileManager.instance.createTempDirectory(string, ".launch");
            Utils.copyDirectory(file6, file, null);
            return file;
        }
        catch (IOException iOException) {
            MTJCorePlugin.throwCoreException(4, -999, iOException);
            return null;
        }
    }

    protected File getJadForLaunch(IMidletSuiteProject iMidletSuiteProject, File file, IProgressMonitor iProgressMonitor) {
        return new File(file, iMidletSuiteProject.getJadFileName());
    }

    protected String getSpecifiedJadURL(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("mtj.specified_jad_url", null);
    }

    protected boolean shouldDirectLaunchJAD(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("mtj.do_jad_launch", false);
    }

    protected boolean shouldDoOTA(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("mtj.do_ota", true);
    }

    protected String urlEncoded(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string2;
    }

    private ILibrary getLibraryWithType(APIType aPIType) {
        ILibrary iLibrary = null;
        Classpath classpath = this.getClasspath();
        ILibrary[] iLibraryArray = classpath.getEntries();
        int n = 0;
        while (n < iLibraryArray.length) {
            if (iLibraryArray[n].getAPI(aPIType) != null) {
                iLibrary = iLibraryArray[n];
                break;
            }
            ++n;
        }
        return iLibrary;
    }

    protected String getOTAURL(ILaunchConfiguration iLaunchConfiguration, IMidletSuiteProject iMidletSuiteProject) throws CoreException {
        try {
            OTAServer.instance.start();
        }
        catch (Exception exception) {
            MTJCorePlugin.log(2, "launch", exception);
        }
        String string = iMidletSuiteProject.getProject().getName();
        String string2 = iMidletSuiteProject.getJadFileName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://localhost:").append(OTAServer.getPort()).append("/ota/").append(this.urlEncoded(string)).append('/').append(this.urlEncoded(string2));
        return stringBuffer.toString();
    }

    protected String getProjectClasspathString(IMidletSuiteProject iMidletSuiteProject, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        de.schlichtherle.io.File file2 = PreverificationBuilder.getRuntimeJar(iMidletSuiteProject.getProject(), iProgressMonitor);
        return new File(file, file2.getName()).getAbsolutePath();
    }
}

