/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.microemu;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.importer.impl.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.library.api.API;
import org.eclipse.mtj.core.model.library.api.APIType;
import org.eclipse.mtj.toolkit.microemu.MicroEmuDevice;
import org.eclipse.mtj.toolkit.microemu.internal.Activator;
import org.eclipse.mtj.toolkit.microemu.internal.MicroEmuDeviceSkin;

public class MicroEmuDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String PROPS_FILE = "microemu.properties";
    private static final String EMULATOR_JAR_NAME = "microemulator.jar";
    private static final String MAIN_CLASS_NAME = "org.microemu.app.Main";
    private static final MicroEmuDeviceSkin[] EMULATOR_DEVICE_SKINS = new MicroEmuDeviceSkin[]{new MicroEmuDeviceSkin("microemulator.jar", "org/microemu/device/default/device.xml", "Default device"), new MicroEmuDeviceSkin("devices/microemu-device-large.jar", "org/microemu/device/large/device.xml", "Large Device"), new MicroEmuDeviceSkin("devices/microemu-device-minimum.jar", "org/microemu/device/minimum/device.xml", "Minimum device")};

    public IDevice[] getMatchingDevices(File file, IProgressMonitor iProgressMonitor) {
        MicroEmuDevice[] microEmuDeviceArray = new MicroEmuDevice[]{};
        try {
            File file2 = new File(file, EMULATOR_JAR_NAME);
            if (file2.exists() && this.hasMainClassAttribute(file2, MAIN_CLASS_NAME)) {
                ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
                int n = 0;
                while (n < EMULATOR_DEVICE_SKINS.length) {
                    IDevice iDevice = this.createDevice(file2, EMULATOR_DEVICE_SKINS[n]);
                    arrayList.add(iDevice);
                    ++n;
                }
                if (!arrayList.isEmpty()) {
                    microEmuDeviceArray = (IDevice[])arrayList.toArray(microEmuDeviceArray);
                }
            }
        }
        catch (Exception exception) {
            MTJCorePlugin.log((int)2, (String)"Error importing MicroEmulator devices", (Throwable)exception);
        }
        return microEmuDeviceArray;
    }

    private Classpath getDeviceClasspath(File file) {
        Classpath classpath = new Classpath();
        this.addDeviceLibraries(file, classpath, new LibraryImporter());
        return classpath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }

    private void addDeviceLibraries(File file, Classpath classpath, LibraryImporter libraryImporter) {
        String string = this.getDeviceProperties().getProperty("classpath", "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("toolkitroot", file.getParent());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray = string.split(";");
        int n = 0;
        while (n < stringArray.length) {
            ILibrary iLibrary = libraryImporter.createLibraryFor(new File(stringArray[n]));
            API aPI = iLibrary.getAPI(APIType.UNKNOWN);
            if (aPI != null) {
                if (aPI.getIdentifier().equalsIgnoreCase("cldcapi11.jar")) {
                    aPI.setIdentifier("CLDC");
                    aPI.setType(APIType.CONFIGURATION);
                    aPI.setName("Connected Limited Device Configuration");
                    aPI.setVersion(new Version("1.1"));
                } else if (aPI.getIdentifier().equalsIgnoreCase("midpapi20.jar")) {
                    aPI.setIdentifier("MIDP");
                    aPI.setType(APIType.PROFILE);
                    aPI.setName("Mobile Information Device Profile");
                    aPI.setVersion(new Version("2.0"));
                }
                classpath.addEntry(iLibrary);
            }
            ++n;
        }
    }

    private IDevice createDevice(File file, MicroEmuDeviceSkin microEmuDeviceSkin) {
        MicroEmuDevice microEmuDevice = new MicroEmuDevice();
        microEmuDevice.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        microEmuDevice.setClasspath(this.getDeviceClasspath(file));
        microEmuDevice.setDebugServer(this.isDebugServer());
        microEmuDevice.setDescription("Microemulator Device");
        microEmuDevice.setDeviceProperties(new Properties());
        microEmuDevice.setGroupName("Microemulator");
        microEmuDevice.setName(microEmuDeviceSkin.getName());
        microEmuDevice.setPreverifier(this.getPreverifier(file));
        microEmuDevice.setProtectionDomains(new String[0]);
        microEmuDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        microEmuDevice.setRoot(file.getParentFile());
        microEmuDevice.setSkin(microEmuDeviceSkin);
        return microEmuDevice;
    }
}

