/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.motorola.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.importer.IDeviceImporter;
import org.eclipse.mtj.core.importer.LibraryImporter;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.Classpath;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.library.ILibrary;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.toolkit.motorola.impl.MotorolaDevice;
import org.eclipse.mtj.toolkit.motorola.internal.MotorolaPlugin;
import org.osgi.framework.Bundle;

public class MotorolaDeviceImporter
implements IDeviceImporter {
    private static final String PROPS_FILE = "moto_emulators.properties";
    private static final String PROPS_EMULATORS_LIST = "emulators.list";
    private static final String LAUNCH_COMMAND_SUFFIX = "_launch.command";
    private static final String EXECUTABLE_SUFFIX = "_executable";
    private static final String PREDEPLOY_REQUIRED_SUFFIX = "_predeploy.required";
    private static final String DEBUG_SERVER_SUFFIX = "_debug.server";
    private static final String DEVICES_SUFFIX = "_devices";
    private Map emulatorDataMap;

    public IDevice[] getMatchingDevices(File file, IProgressMonitor iProgressMonitor) {
        IDevice[] iDeviceArray = null;
        File file2 = new File(file, "resources");
        if (file2.exists()) {
            iDeviceArray = this.getResourcesDevices(file2, iProgressMonitor);
        }
        return iDeviceArray;
    }

    private IDevice createDevice(File file, Properties properties, String string) {
        IDevice iDevice = null;
        EmulatorData emulatorData = this.getEmulatorData(string);
        if (emulatorData != null) {
            iDevice = this.createDevice(file, properties, string, emulatorData);
        }
        return iDevice;
    }

    private IDevice createDevice(File file, Properties properties, String string, EmulatorData emulatorData) {
        File file2 = file.getParentFile().getParentFile();
        File file3 = file2.getParentFile();
        File file4 = file3.getParentFile();
        MotorolaDevice motorolaDevice = new MotorolaDevice();
        try {
            motorolaDevice.setBundle(MotorolaPlugin.getDefault().getBundle().getSymbolicName());
            motorolaDevice.setClasspath(this.getClasspath(file3));
            motorolaDevice.setDebugServer(emulatorData.debugServer);
            motorolaDevice.setDescription(string);
            motorolaDevice.setDeviceProperties(properties);
            motorolaDevice.setExecutable(new File(file2, emulatorData.executable));
            motorolaDevice.setGroupName(file4.getName());
            motorolaDevice.setName(string);
            motorolaDevice.setPreverifier(this.getPreverifier(file2, file4));
            motorolaDevice.setPropertiesFile(file);
            motorolaDevice.setProtectionDomains(new String[0]);
            motorolaDevice.setLaunchCommandTemplate(emulatorData.launchCommandTemplate);
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)("Error importing device " + string), (Throwable)coreException);
            motorolaDevice = null;
        }
        return motorolaDevice;
    }

    private File findPreverifyExecutable(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.equals("preverify.exe") || string.equals("preverify");
            }
        });
        File file2 = null;
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].isDirectory()) {
                file2 = fileArray[n];
                break;
            }
            file2 = this.findPreverifyExecutable(fileArray[n]);
            ++n;
        }
        return file2;
    }

    private Classpath getClasspath(File file) {
        Classpath classpath = new Classpath();
        File file2 = new File(file, "lib");
        File[] fileArray = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isFile() && (string.endsWith(".zip") || string.endsWith(".jar"));
            }
        });
        LibraryImporter libraryImporter = new LibraryImporter();
        int n = 0;
        while (n < fileArray.length) {
            ILibrary iLibrary = libraryImporter.createLibraryFor(fileArray[n]);
            classpath.addEntry(iLibrary);
            ++n;
        }
        return classpath;
    }

    private EmulatorData getEmulatorData(String string) {
        return (EmulatorData)this.getEmulatorDataMap().get(string);
    }

    private Map getEmulatorDataMap() {
        if (this.emulatorDataMap == null) {
            this.emulatorDataMap = this.readEmulatorDataMap();
        }
        return this.emulatorDataMap;
    }

    private IPreverifier getPreverifier(File file, File file2) throws CoreException {
        File file3 = this.findPreverifyExecutable(file);
        if (file3 == null) {
            file3 = this.findPreverifyExecutable(file2);
        }
        return StandardPreverifierFactory.createPreverifier((File)file3);
    }

    private Properties getProperties(File file) {
        Properties properties;
        block14: {
            properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                }
                catch (IOException iOException) {
                    MTJCorePlugin.log((int)2, (String)("Error reading properties file " + file), (Throwable)iOException);
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private IDevice[] getResourcesDevices(File file, IProgressMonitor iProgressMonitor) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".props");
            }
        });
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        int n = 0;
        while (n < fileArray.length) {
            IDevice iDevice;
            File file2 = fileArray[n];
            Properties properties = this.getProperties(file2);
            String string = properties.getProperty("devicename");
            if (string != null && (iDevice = this.createDevice(file2, properties, string)) != null) {
                arrayList.add(iDevice);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new IDevice[arrayList.size()]);
    }

    private Map parseEmulatorDataProperties(Properties properties) {
        HashMap hashMap = new HashMap();
        String string = properties.getProperty(PROPS_EMULATORS_LIST, "");
        String[] stringArray = string.split(",");
        int n = 0;
        while (n < stringArray.length) {
            this.parseEmulatorDataProperties(hashMap, properties, stringArray[n]);
            ++n;
        }
        return hashMap;
    }

    private void parseEmulatorDataProperties(Map map, Properties properties, String string) {
        String string2 = properties.getProperty(String.valueOf(string) + DEVICES_SUFFIX, "");
        String string3 = properties.getProperty(String.valueOf(string) + DEBUG_SERVER_SUFFIX, "");
        String string4 = properties.getProperty(String.valueOf(string) + PREDEPLOY_REQUIRED_SUFFIX, "");
        EmulatorData emulatorData = new EmulatorData();
        emulatorData.emulator = string;
        emulatorData.executable = properties.getProperty(String.valueOf(string) + EXECUTABLE_SUFFIX, "");
        emulatorData.launchCommandTemplate = properties.getProperty(String.valueOf(string) + LAUNCH_COMMAND_SUFFIX, "");
        emulatorData.devices = string2.length() > 0 ? string2.split(",") : new String[0];
        emulatorData.debugServer = string3.equalsIgnoreCase("true");
        emulatorData.predeployRequired = string4.equalsIgnoreCase("true");
        int n = 0;
        while (n < emulatorData.devices.length) {
            String string5 = emulatorData.devices[n];
            map.put(string5, emulatorData);
            ++n;
        }
    }

    private Map readEmulatorDataMap() {
        Properties properties;
        block15: {
            properties = new Properties();
            InputStream inputStream = null;
            try {
                try {
                    Bundle bundle = MotorolaPlugin.getDefault().getBundle();
                    URL uRL = bundle.getEntry(PROPS_FILE);
                    inputStream = uRL.openStream();
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                }
                catch (IOException iOException) {
                    MTJCorePlugin.log((int)4, (String)"Error loading Motorola emulator properties", (Throwable)iOException);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.parseEmulatorDataProperties(properties);
    }

    private class EmulatorData {
        public String emulator;
        public String[] devices;
        public String executable;
        public String launchCommandTemplate;
        public boolean debugServer;
        public boolean predeployRequired;

        private EmulatorData() {
        }
    }
}

