/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.mpowerplayer;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.model.LaunchEnvironment;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.core.model.device.impl.JavaEmulatorDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class MpowerplayerDevice
extends JavaEmulatorDevice {
    private File mppRoot;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor iProgressMonitor) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject = launchEnvironment.getMidletSuite();
        ILaunchConfiguration iLaunchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean bl = this.shouldDirectLaunchJAD(iLaunchConfiguration);
        File file = this.copyForLaunch(iMidletSuiteProject, iProgressMonitor, bl);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("executable", this.getJavaExecutable());
        hashMap.put("mpproot", this.mppRoot);
        if (launchEnvironment.isDebugLaunch()) {
            hashMap.put("debugPort", new Integer(launchEnvironment.getDebugListenerPort()));
        }
        String string = iLaunchConfiguration.getAttribute("mtj.launch_params", "");
        hashMap.put("userSpecifiedArguments", string);
        if (bl) {
            hashMap.put("jadfile", this.getSpecifiedJadURL(iLaunchConfiguration));
        } else {
            File file2 = this.getJadForLaunch(iMidletSuiteProject, file, iProgressMonitor);
            if (file2.exists()) {
                hashMap.put("jadfile", file2.toString());
            }
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, hashMap);
    }

    public File getMppRoot() {
        return this.mppRoot;
    }

    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.loadUsing(iPersistenceProvider);
        String string = iPersistenceProvider.loadString("mppRoot");
        this.mppRoot = new File(string);
    }

    public void setMppRoot(File file) {
        this.mppRoot = file;
    }

    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        super.storeUsing(iPersistenceProvider);
        iPersistenceProvider.storeString("mppRoot", this.mppRoot.toString());
    }
}

