/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.toolkit.uei;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.internal.utils.Utils;

public class UEIPropertiesReader {
    public static final UEIPropertiesReader instance = new UEIPropertiesReader();
    private static final Pattern VALID_VERSION_PATTERN = Pattern.compile("^Profile:\\s.*|^Configuration:\\s.*", 8);
    private static final String PARM_XQUERY = "-Xquery";

    private UEIPropertiesReader() {
    }

    public Properties getUEIProperties(File file) throws CoreException {
        Properties properties = null;
        try {
            properties = this.getUEIPropertiesFromEmulator(file);
        }
        catch (IOException iOException) {
            MTJCorePlugin.throwCoreException((int)4, (int)-9999, (Throwable)iOException);
        }
        return properties;
    }

    private String getStandardOutput(String string, File file, String[] stringArray) throws CoreException {
        boolean bl = Platform.getOS().equals("win32");
        File file2 = file.getParentFile();
        String string2 = bl ? file.getName() : file.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>((Collection)Arrays.asList(stringArray));
        arrayList.add(0, string2);
        if (bl) {
            arrayList.add(0, "/c");
            arrayList.add(0, "cmd");
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        return Utils.getStandardOutput((String)"UEI Emulator Version", (String[])stringArray2, (File)file2);
    }

    private String getToolkitName(String string) throws IOException {
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        string2 = bufferedReader.readLine();
        if (string2 == null) {
            string2 = "Generic UEI Toolkit";
        }
        return string2;
    }

    private Properties getUEIPropertiesFromEmulator(File file) throws CoreException, IOException {
        Properties properties = null;
        if (Utils.executableExists((File)file)) {
            String string = this.getUEIVersionInformation(file);
            Matcher matcher = VALID_VERSION_PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = this.getStandardOutput("UEI Emulator Query", file, new String[]{PARM_XQUERY});
                properties = this.parseUEIPropertiesString(string2);
                String string3 = this.getToolkitName(string);
                if (string3 != null && string3.length() > 0) {
                    properties.setProperty("org.eclipse.mtj.toolkit.name", string3);
                }
            }
        } else {
            properties = new Properties();
        }
        return properties;
    }

    private String getUEIVersionInformation(File file) throws CoreException {
        return this.getStandardOutput("UEI Emulator Version", file, new String[]{"-version"});
    }

    private Properties parseUEIPropertiesString(String string) throws IOException {
        ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
        StringReader stringReader = new StringReader(string);
        try {
            colonDelimitedProperties.load((Reader)stringReader);
        }
        catch (Exception exception) {
            MTJCorePlugin.log((int)2, (String)"Error parsing UEI properties", (Throwable)exception);
            MTJCorePlugin.log((int)2, (String)string);
        }
        return colonDelimitedProperties;
    }
}

