/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.widgets.Shell;

public class MTJUIErrors {
    public static final String MESSAGE_PREFIX = "MTJUIError.";
    public static final int UI_ERROR_BASE = 110000;
    public static final int UI_ERROR_EXCEPTION = 110001;
    public static final int UI_WARNING_BASE = 120000;
    public static final int UI_INTERNAL_BASE = 190000;

    public static final String getErrorMessage(int n) {
        String string = MTJUIStrings.getBundleString(MESSAGE_PREFIX + n);
        if (string == null) {
            string = n < 190000 ? MTJUIStrings.getString("MTJUIError.Default") : MTJUIStrings.getString("MTJUIError.InternalTemplate");
        }
        String string2 = MessageFormat.format(string, n);
        return string2;
    }

    public static void throwCoreExceptionError(int n) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.ui", n, MTJUIErrors.getErrorMessage(n), null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreExceptionError(int n, Throwable throwable) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.ui", n, MTJUIErrors.getErrorMessage(n), throwable);
        throw new CoreException((IStatus)status);
    }

    public static void displayError(Shell shell, String string, String string2, IStatus iStatus) {
        if (string == null) {
            string = "MTJUIError.Default";
        }
        if (string2 == null) {
            string2 = "MTJUIError.Default";
        }
        int n = 0;
        if (iStatus != null) {
            n = iStatus.getCode();
        }
        Object[] objectArray = new Integer[]{n};
        String string3 = MessageFormat.format(MTJUIStrings.getString(string), objectArray);
        String string4 = MessageFormat.format(MTJUIStrings.getString(string2), objectArray);
        ErrorDialog.openError((Shell)shell, (String)string3, (String)string4, (IStatus)iStatus);
    }

    public static void displayError(Shell shell, String string, String string2, Exception exception) {
        if (string == null) {
            string = "MTJUIError.Default";
        }
        if (string2 == null) {
            string2 = "MTJUIError.Default";
        }
        Object[] objectArray = new String[]{exception.getMessage()};
        String string3 = exception.getMessage();
        if (string3 == null) {
            string3 = "No Message";
        }
        Status status = new Status(4, "org.eclipse.mtj.ui", 110001, string3, (Throwable)exception);
        String string4 = MessageFormat.format(MTJUIStrings.getString(string), objectArray);
        String string5 = MessageFormat.format(MTJUIStrings.getString(string2), objectArray);
        MTJUIPlugin.getDefault().getLog().log((IStatus)status);
        ErrorDialog.openError((Shell)shell, (String)string4, (String)string5, (IStatus)status);
    }
}

