/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;
import org.eclipse.mtj.core.nature.J2MENature;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.ui.internal.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.ui.internal.dialog.DeviceSelectDialog;
import org.eclipse.swt.widgets.Shell;

public class ConvertToMidletSuiteAction
extends AbstractJavaProjectAction {
    public void run(IAction iAction) {
        if (this.selection != null && !this.selection.isEmpty()) {
            try {
                IDevice iDevice = this.getDevice();
                if (iDevice == null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error During Conversion", (String)"No Device Available or Selected for Conversion");
                } else {
                    this.convertSelectedProjects(iDevice);
                }
            }
            catch (PersistenceException persistenceException) {
                this.handleException(persistenceException);
            }
        }
    }

    private void convertProject(IJavaProject iJavaProject, IDevice iDevice, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException, JavaModelException {
        IProject iProject = iJavaProject.getProject();
        String string = MidletSuiteProject.getDefaultJadFileName((IProject)iProject);
        MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)iProject, (IJavaProject)iJavaProject, (IDevice)iDevice, (String)string).run(iProgressMonitor);
        this.removeJ2SELibraries(iJavaProject, iProgressMonitor);
    }

    private void convertSelectedProjects(IDevice iDevice) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.open();
            IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
            MTJCorePlugin.getWorkspace().run(this.getRunnable(iDevice), iProgressMonitor);
            progressMonitorDialog.close();
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
    }

    private IDevice getDevice() throws PersistenceException {
        DeviceSelectDialog deviceSelectDialog;
        IDevice iDevice = null;
        if (DeviceRegistry.singleton.getDeviceCount() > 0 && (deviceSelectDialog = new DeviceSelectDialog(this.getShell())).open() == 0) {
            iDevice = deviceSelectDialog.getSelectedDevice();
        }
        return iDevice;
    }

    private IWorkspaceRunnable getRunnable(final IDevice iDevice) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask("Converting Projects", ConvertToMidletSuiteAction.this.selection.size());
                Iterator iterator = ConvertToMidletSuiteAction.this.selection.iterator();
                while (iterator.hasNext()) {
                    IJavaProject iJavaProject = ConvertToMidletSuiteAction.this.getJavaProject(iterator.next());
                    if (iJavaProject != null) {
                        iProgressMonitor.setTaskName("Converting Project " + iJavaProject.getElementName());
                        boolean bl = false;
                        try {
                            IProject iProject = iJavaProject.getProject();
                            bl = J2MENature.hasJ2MENature((IProject)iProject);
                        }
                        catch (CoreException coreException) {}
                        if (!bl) {
                            try {
                                ConvertToMidletSuiteAction.this.convertProject(iJavaProject, iDevice, iProgressMonitor);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                MTJCorePlugin.throwCoreException((int)4, (int)-999, (Throwable)invocationTargetException.getTargetException());
                            }
                            catch (InterruptedException interruptedException) {
                                MTJCorePlugin.throwCoreException((int)4, (int)-999, (Throwable)interruptedException);
                            }
                        }
                    }
                    iProgressMonitor.worked(1);
                }
                iProgressMonitor.done();
            }
        };
    }

    private void handleException(Throwable throwable) {
        MTJCorePlugin.log((int)4, (Throwable)throwable);
        MessageDialog.openError((Shell)this.getShell(), (String)"Error During Conversion", (String)throwable.toString());
    }

    private boolean isJ2SELibraryEntry(IClasspathEntry iClasspathEntry) {
        boolean bl = false;
        if (iClasspathEntry.getEntryKind() == 1) {
            if (iClasspathEntry.getPath().lastSegment().equals("JRE_LIB")) {
                bl = true;
            }
        } else if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            bl = true;
        }
        return bl;
    }

    private void removeJ2SELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (!this.isJ2SELibraryEntry(iClasspathEntryArray[n])) {
                arrayList.add(iClasspathEntryArray[n]);
            }
            ++n;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
    }
}

