/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.devices;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.devices.DeviceEditorConfigElement;

public class DeviceEditorRegistry {
    public static final String ID_EXTENSION = "deviceEditor";
    private static DeviceEditorConfigElement[] editors;

    public static DeviceEditorConfigElement findEditorElement(IDevice iDevice) {
        DeviceEditorConfigElement deviceEditorConfigElement = null;
        DeviceEditorConfigElement[] deviceEditorConfigElementArray = DeviceEditorRegistry.getEditors();
        Class<?> clazz = iDevice.getClass();
        int n = 0;
        while (n < deviceEditorConfigElementArray.length) {
            String string = deviceEditorConfigElementArray[n].getDeviceClass();
            if (DeviceEditorRegistry.isMatchingType(clazz, string)) {
                deviceEditorConfigElement = deviceEditorConfigElementArray[n];
                break;
            }
            ++n;
        }
        return deviceEditorConfigElement;
    }

    private static boolean isMatchingType(Class clazz, String string) {
        boolean bl = false;
        if (clazz != null) {
            bl = clazz.getName().equals(string);
            if (!bl) {
                bl = DeviceEditorRegistry.isMatchingType(clazz.getSuperclass(), string);
            }
            if (!bl) {
                Class<?>[] classArray = clazz.getInterfaces();
                int n = 0;
                while (!bl && n < classArray.length) {
                    bl = DeviceEditorRegistry.isMatchingType(classArray[n], string);
                    ++n;
                }
            }
        }
        return bl;
    }

    private static DeviceEditorConfigElement[] getEditors() {
        if (editors == null) {
            editors = DeviceEditorRegistry.readEditors();
        }
        return editors;
    }

    private static DeviceEditorConfigElement[] readEditors() {
        String string = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, ID_EXTENSION);
        DeviceEditorConfigElement[] deviceEditorConfigElementArray = new DeviceEditorConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            deviceEditorConfigElementArray[n] = new DeviceEditorConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return deviceEditorConfigElementArray;
    }

    private DeviceEditorRegistry() {
    }
}

