/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editor.jad.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.jad.DescriptorPropertyDescription;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.jadEditor.IJADDescriptorsProvider;

public class JADAttributesRegistry {
    public static final String JAD_ATTRIBUTE_EXTENSION = "jadAttributes";
    private static Map<String, JADAttributesConfigElement[]> genericPageJADAttrMap = new HashMap<String, JADAttributesConfigElement[]>();
    private static JADAttributesConfigElement[] allJADAttrElements;

    public static DescriptorPropertyDescription[] getJADAttrDescriptorsByPage(String string) {
        JADAttributesConfigElement[] jADAttributesConfigElementArray = JADAttributesRegistry.getRelatedAttrElements(string);
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = JADAttributesRegistry.getDescriptorsFromElements(jADAttributesConfigElementArray);
        return descriptorPropertyDescriptionArray;
    }

    private static JADAttributesConfigElement[] getRelatedAttrElements(String string) {
        JADAttributesConfigElement[] jADAttributesConfigElementArray = null;
        if (!genericPageJADAttrMap.containsKey(string)) {
            genericPageJADAttrMap.put(string, JADAttributesRegistry.getGenericElements(string));
        }
        jADAttributesConfigElementArray = genericPageJADAttrMap.get(string);
        return jADAttributesConfigElementArray;
    }

    private static JADAttributesConfigElement[] getGenericElements(String string) {
        JADAttributesConfigElement[] jADAttributesConfigElementArray = JADAttributesRegistry.getAllJADAttributeElements();
        return JADAttributesRegistry.filterElementsByPageAndVendorSpec(jADAttributesConfigElementArray, string, true);
    }

    private static JADAttributesConfigElement[] filterElementsByPageAndVendorSpec(JADAttributesConfigElement[] jADAttributesConfigElementArray, String string, boolean bl) {
        return JADAttributesRegistry.filterElements(jADAttributesConfigElementArray, null, string, bl);
    }

    private static JADAttributesConfigElement[] filterElements(JADAttributesConfigElement[] jADAttributesConfigElementArray, IDevice iDevice, String string, boolean bl) {
        ArrayList<JADAttributesConfigElement> arrayList = new ArrayList<JADAttributesConfigElement>();
        int n = 0;
        while (n < jADAttributesConfigElementArray.length) {
            JADAttributesConfigElement jADAttributesConfigElement = jADAttributesConfigElementArray[n];
            boolean bl2 = true;
            if (iDevice != null) {
                bl2 &= jADAttributesConfigElement.isVendorSpec() && JADAttributesRegistry.isDeviceMatchVendor(iDevice, jADAttributesConfigElement);
            }
            if (string != null) {
                bl2 &= jADAttributesConfigElement.getAttributesShowPage().equalsIgnoreCase(string);
            }
            if (bl) {
                bl2 &= !jADAttributesConfigElement.isVendorSpec();
            }
            if (bl2) {
                arrayList.add(jADAttributesConfigElement);
            }
            ++n;
        }
        return arrayList.toArray(new JADAttributesConfigElement[0]);
    }

    private static boolean isDeviceMatchVendor(IDevice iDevice, JADAttributesConfigElement jADAttributesConfigElement) {
        return true;
    }

    private static DescriptorPropertyDescription[] getDescriptorsFromElements(JADAttributesConfigElement[] jADAttributesConfigElementArray) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < jADAttributesConfigElementArray.length) {
            JADAttributesConfigElement jADAttributesConfigElement = jADAttributesConfigElementArray[n];
            try {
                IJADDescriptorsProvider iJADDescriptorsProvider = jADAttributesConfigElement.getJadDescriptorsProvider();
                DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = iJADDescriptorsProvider.getDescriptorPropertyDescriptions();
                arrayList.addAll(Arrays.asList(descriptorPropertyDescriptionArray));
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)2, (String)"Errors happens while judging the device has vendor specifc JAD attributes", (Throwable)exception);
            }
            ++n;
        }
        return arrayList.toArray(new DescriptorPropertyDescription[arrayList.size()]);
    }

    private static JADAttributesConfigElement[] getAllJADAttributeElements() {
        if (allJADAttrElements == null) {
            allJADAttrElements = JADAttributesRegistry.readAllJADAttributes();
        }
        return allJADAttrElements;
    }

    private static JADAttributesConfigElement[] readAllJADAttributes() {
        String string = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string, JAD_ATTRIBUTE_EXTENSION);
        JADAttributesConfigElement[] jADAttributesConfigElementArray = new JADAttributesConfigElement[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            jADAttributesConfigElementArray[n] = new JADAttributesConfigElement(iConfigurationElementArray[n]);
            ++n;
        }
        return jADAttributesConfigElementArray;
    }

    static class JADAttributesConfigElement {
        private static final String JAD_DESCRIPTOR_PROVIDER_ELEMENT = "jadDescriptorsProvider";
        private static final String JAD_DESCRIPTOR_PROVIDER_CLASS = "class";
        private static final String JAD_ATTR_SHOW_PAGE = "pageID";
        private static final String VENDOR_SPEC_ATTR = "vendorSpec";
        private IConfigurationElement element;
        private IJADDescriptorsProvider jadDescriptorsProvider;

        public JADAttributesConfigElement(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IJADDescriptorsProvider getJadDescriptorsProvider() throws CoreException {
            IConfigurationElement[] iConfigurationElementArray;
            if (this.jadDescriptorsProvider == null && (iConfigurationElementArray = this.element.getChildren(JAD_DESCRIPTOR_PROVIDER_ELEMENT)) != null && iConfigurationElementArray.length > 0) {
                this.jadDescriptorsProvider = (IJADDescriptorsProvider)iConfigurationElementArray[0].createExecutableExtension(JAD_DESCRIPTOR_PROVIDER_CLASS);
            }
            return this.jadDescriptorsProvider;
        }

        public String getAttributesShowPage() {
            return this.element.getAttribute(JAD_ATTR_SHOW_PAGE);
        }

        public boolean isVendorSpec() {
            String string = this.element.getAttribute(VENDOR_SPEC_ATTR);
            return string == null ? false : "true".equalsIgnoreCase(string);
        }
    }
}

