/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editor.jad.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.editor.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.mtj.ui.internal.utils.MidletSelectionDialogCreator;
import org.eclipse.mtj.ui.jadEditor.AbstractJADEditorPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADMidletsEditorPage
extends AbstractJADEditorPage {
    public static final String ID = "midlets";
    private static final String PROP_NAME = "name";
    private static final String PROP_ICON = "icon";
    private static final String PROP_CLASS = "class";
    private static final String[] PROPERTIES = new String[]{"name", "icon", "class"};
    private static final List PROPERTY_LIST = Arrays.asList(PROPERTIES);
    public static final String MIDLET_PREFIX = "MIDlet-";
    private ArrayList midlets = new ArrayList();
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private int storedMidletCount;

    public JADMidletsEditorPage(JADFormEditor jADFormEditor, String string) {
        super(jADFormEditor, ID, string);
    }

    public JADMidletsEditorPage() {
        super(ID, JADMidletsEditorPage.getResourceString("editor.jad.tab.midlets"));
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        int n = this.midlets.size();
        int n2 = 0;
        while (n2 < n) {
            MidletDefinition midletDefinition = (MidletDefinition)this.midlets.get(n2);
            manifestPreferenceStore.setValue(MIDLET_PREFIX + (n2 + 1), midletDefinition.toString());
            ++n2;
        }
        while (n2 < this.storedMidletCount) {
            manifestPreferenceStore.setToDefault(MIDLET_PREFIX + (n2 + 1));
            ++n2;
        }
        this.storedMidletCount = n;
        this.setDirty(false);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = this.createSectionComposite(iManagedForm);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        this.createTableViewer(formToolkit, composite);
        this.createButtons(formToolkit, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_JADMidletsEditorPage");
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected String getSectionTitle() {
        return "MIDlets";
    }

    protected String getSectionDescription() {
        return "Define the MIDlets that make up the MIDlet Suite";
    }

    public void editorInputChanged() {
        this.updateMidletProperties();
    }

    public boolean isManagingProperty(String string) {
        boolean bl = string.startsWith(MIDLET_PREFIX);
        if (bl) {
            String string2 = string.substring(MIDLET_PREFIX.length());
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)iEditorInput);
        }
        this.setDirty(false);
        this.updateMidletProperties();
    }

    private void addItem() {
        MidletDefinition midletDefinition = new MidletDefinition("New MIDlet", "", "");
        this.midlets.add(midletDefinition);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        this.addButton = formToolkit.createButton(composite2, JADMidletsEditorPage.getResourceString("editor.button.add"), 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADMidletsEditorPage.this.addItem();
            }
        });
        formToolkit.createLabel(composite2, "");
        this.removeButton = formToolkit.createButton(composite2, JADMidletsEditorPage.getResourceString("editor.button.remove"), 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADMidletsEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit formToolkit, Composite composite) {
        String[] stringArray = new String[]{JADMidletsEditorPage.getResourceString("property.jad.midlet.name"), JADMidletsEditorPage.getResourceString("property.jad.midlet.icon"), JADMidletsEditorPage.getResourceString("property.jad.midlet.class")};
        int n = 68356;
        Table table = formToolkit.createTable(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                JADMidletsEditorPage.this.removeButton.setEnabled(tableItem.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout();
        int n2 = 100 / stringArray.length;
        int n3 = 0;
        while (n3 < stringArray.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n3]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(n2));
            ++n3;
        }
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new MidletCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private IJavaProject getJavaProject() {
        IProject iProject = this.getProject();
        return iProject == null ? null : JavaCore.create((IProject)iProject);
    }

    private IProject getProject() {
        IProject iProject = null;
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            iProject = iFile.getProject();
        }
        return iProject;
    }

    private void removeSelectedItems() {
        int[] nArray = this.tableViewer.getTable().getSelectionIndices();
        int n = nArray.length;
        while (n > 0) {
            int n2 = nArray[n - 1];
            this.midlets.remove(n2);
            --n;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        this.midlets.clear();
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        int n = 1;
        while (n < 1000) {
            String string = MIDLET_PREFIX + n;
            if (!manifestPreferenceStore.contains(string)) break;
            String string2 = manifestPreferenceStore.getString(string);
            this.midlets.add(new MidletDefinition(string2));
            ++n;
        }
        this.storedMidletCount = this.midlets.size();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private static String getResourceString(String string) {
        return MTJUIStrings.getString(string);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (object instanceof MidletDefinition) {
                MidletDefinition midletDefinition = (MidletDefinition)object;
                int n = this.getFieldIndex(string);
                if (n != -1) {
                    string2 = midletDefinition.fields[n];
                }
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = (String)object2;
                if (object3 instanceof MidletDefinition) {
                    int n = this.getFieldIndex(string);
                    MidletDefinition midletDefinition = (MidletDefinition)object3;
                    if (n != -1) {
                        this.updateField(midletDefinition, string, n, string2);
                    }
                }
            }
        }

        private int getFieldIndex(String string) {
            return PROPERTY_LIST.indexOf(string);
        }

        private void updateField(MidletDefinition midletDefinition, String string, int n, String string2) {
            if (!midletDefinition.fields[n].equals(string2)) {
                midletDefinition.fields[n] = string2;
                JADMidletsEditorPage.this.setDirty(true);
                JADMidletsEditorPage.this.tableViewer.update((Object)midletDefinition, new String[]{string});
            }
        }
    }

    private class MidletCellEditor
    extends DialogCellEditor {
        MidletCellEditor(Composite composite) {
            super(composite);
        }

        protected Object openDialogBox(Control control) {
            String string = null;
            try {
                IType iType;
                Object[] objectArray;
                IJavaProject iJavaProject = JADMidletsEditorPage.this.getJavaProject();
                SelectionDialog selectionDialog = MidletSelectionDialogCreator.createMidletSelectionDialog(control.getShell(), (IRunnableContext)JADMidletsEditorPage.this.getSite().getPage().getWorkbenchWindow(), iJavaProject, false);
                if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                    string = iType.getFullyQualifiedName();
                }
            }
            catch (JavaModelException javaModelException) {
                MTJCorePlugin.log((int)4, (String)"openDialogBox", (Throwable)javaModelException);
            }
            return string;
        }
    }

    static class MidletDefinition {
        public String[] fields = new String[3];

        MidletDefinition(String string) {
            String[] stringArray = this.tokenize(string, ',');
            int n = 0;
            while (n < 3) {
                this.fields[n] = n > stringArray.length ? "" : stringArray[n];
                ++n;
            }
        }

        MidletDefinition(String string, String string2, String string3) {
            this.fields[0] = string;
            this.fields[1] = string2;
            this.fields[2] = string3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < 3) {
                if (n != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.fields[n]);
                ++n;
            }
            return stringBuffer.toString();
        }

        private String[] tokenize(String string, char c) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            int n2 = 0;
            do {
                if ((n2 = string.indexOf(c, n)) == -1) {
                    arrayList.add(string.substring(n));
                    continue;
                }
                arrayList.add(string.substring(n, n2));
                n = n2 + 1;
            } while (n2 != -1);
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object object) {
            return JADMidletsEditorPage.this.midlets.toArray(new Object[JADMidletsEditorPage.this.midlets.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return ((MidletDefinition)object).fields[n];
        }
    }
}

