/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class EmulatorLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)iSelection).toArray(), string);
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IJavaElement iJavaElement = (IJavaElement)iEditorInput.getAdapter(IJavaElement.class);
        if (iJavaElement != null) {
            this.launch(new Object[]{iJavaElement}, string);
        }
    }

    private ILaunchConfiguration chooseConfiguration(List list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle("Launch configuration");
        elementListSelectionDialog.setMessage("Select launch configuration");
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IType chooseType(IType[] iTypeArray, String string) {
        IType iType = null;
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        elementListSelectionDialog.setElements((Object[])iTypeArray);
        elementListSelectionDialog.setTitle("Type Selection");
        if (string.equals("debug")) {
            elementListSelectionDialog.setMessage("Select the midlet to be debugged.");
        } else {
            elementListSelectionDialog.setMessage("Select the midlet to be run.");
        }
        elementListSelectionDialog.setMultipleSelection(false);
        if (elementListSelectionDialog.open() == 0) {
            iType = (IType)elementListSelectionDialog.getFirstResult();
        }
        return iType;
    }

    private void collectTypes(Object object, IProgressMonitor iProgressMonitor, Set set) throws JavaModelException {
        IType iType = null;
        if (object instanceof ICompilationUnit) {
            IType[] iTypeArray = ((ICompilationUnit)object).getAllTypes();
            int n = 0;
            while (n < iTypeArray.length) {
                this.collectTypes(iTypeArray[n], iProgressMonitor, set);
                ++n;
            }
        } else if (object instanceof IClassFile) {
            iType = ((IClassFile)object).getType();
        } else if (object instanceof IJavaElement) {
            iType = (IType)((IJavaElement)object).getAncestor(7);
        } else if (object instanceof IResource) {
            this.collectTypes(JavaCore.create((IResource)((IResource)object)), iProgressMonitor, set);
        }
        if (iType != null && Utils.isMidlet((IType)iType, (IProgressMonitor)iProgressMonitor)) {
            set.add(iType);
        }
    }

    private ILaunchConfiguration createConfiguration(IType iType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getEmulatorConfigType();
            String string = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iType.getElementName());
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_class", Utils.getQualifiedClassName((IType)iType));
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, iType.getJavaProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"debug", (String)"perspective_default");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"createConfiguration", (Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    private ILaunchConfiguration findLaunchConfiguration(IType iType, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        List list = this.getCandidateConfigs(iType);
        int n = list.size();
        if (n < 1) {
            iLaunchConfiguration = this.createConfiguration(iType);
        } else if (n == 1) {
            iLaunchConfiguration = (ILaunchConfiguration)list.get(0);
        } else {
            ILaunchConfiguration iLaunchConfiguration2 = this.chooseConfiguration(list, string);
            if (iLaunchConfiguration2 != null) {
                iLaunchConfiguration = iLaunchConfiguration2;
            }
        }
        return iLaunchConfiguration;
    }

    private List getCandidateConfigs(IType iType) {
        ILaunchConfigurationType iLaunchConfigurationType = this.getEmulatorConfigType();
        ArrayList<ILaunchConfiguration> arrayList = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            arrayList = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n];
                String string = iLaunchConfiguration.getAttribute("mtj.emulated_class", "");
                String string2 = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (string.equals(Utils.getQualifiedClassName((IType)iType)) && string2.equals(iType.getJavaProject().getElementName())) {
                    arrayList.add(iLaunchConfiguration);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"getCandidateConfigs", (Throwable)coreException);
        }
        return arrayList;
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return iLaunchConfigurationType;
    }

    private IType[] findTypes(Object[] objectArray) {
        HashSet hashSet = new HashSet();
        if (objectArray.length > 0) {
            IRunnableWithProgress iRunnableWithProgress = this.getTypeCollectionRunnable(objectArray, hashSet);
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                MTJCorePlugin.log((int)2, (String)"findTypes", (Throwable)invocationTargetException);
            }
            catch (InterruptedException interruptedException) {}
        }
        return hashSet.toArray(new IType[hashSet.size()]);
    }

    private IRunnableWithProgress getTypeCollectionRunnable(final Object[] objectArray, final Set set) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                int n = objectArray.length;
                iProgressMonitor.beginTask("Searching", n);
                try {
                    int n2 = 0;
                    while (n2 < n) {
                        try {
                            EmulatorLaunchShortcut.this.collectTypes(objectArray[n2], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), set);
                        }
                        catch (JavaModelException javaModelException) {
                            MTJCorePlugin.log((int)2, (String)"collectTypes", (Throwable)javaModelException);
                        }
                        if (iProgressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ++n2;
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow iWorkbenchWindow = MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            shell = iWorkbenchWindow.getShell();
        }
        return shell;
    }

    private void launch(Object[] objectArray, String string) {
        ILaunchConfiguration iLaunchConfiguration;
        IType iType = null;
        IType[] iTypeArray = this.findTypes(objectArray);
        if (iTypeArray.length == 1) {
            iType = iTypeArray[0];
        } else if (iTypeArray.length > 1) {
            iType = this.chooseType(iTypeArray, string);
        }
        if (iType != null && (iLaunchConfiguration = this.findLaunchConfiguration(iType, string)) != null) {
            try {
                iLaunchConfiguration.launch(string, null);
            }
            catch (CoreException coreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)("Error Launching " + iLaunchConfiguration.getName()), (String)coreException.getMessage(), (IStatus)coreException.getStatus());
            }
        }
    }
}

