/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.utils.MidletSelectionDialogCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MidletTab
extends JavaMainTab {
    private Text projectText;
    private Label projectLabel;
    private Text midletText;
    private Button midletRadio;
    private Button otaRadio;
    private Button searchButton;
    private Button projectButton;
    private Button jadRadio;
    private Text jadText;
    private Button jadBrowseButton;

    private IJavaProject chooseJavaProject() {
        IWorkspaceRoot iWorkspaceRoot;
        IJavaProject iJavaProject = null;
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle("Project Selection");
        elementListSelectionDialog.setMessage("Select a project from the list");
        try {
            iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            elementListSelectionDialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)iWorkspaceRoot).getJavaProjects());
        }
        catch (JavaModelException javaModelException) {
            MTJCorePlugin.log((int)2, (Throwable)javaModelException);
        }
        iWorkspaceRoot = this.getJavaProject();
        if (iWorkspaceRoot != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iWorkspaceRoot});
        }
        if (elementListSelectionDialog.open() == 0) {
            iJavaProject = (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return iJavaProject;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(composite2, 3);
        this.createProjectComponents(composite2);
        this.createVerticalSpacer(composite2, 3);
        this.createExecutableComponents(composite2);
        this.updateEnablement();
    }

    private void createExecutableComponents(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        group.setText(" Executable ");
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        group.setFont(font);
        this.createMidletComponents(group);
        this.createJadComponents(group);
        this.otaRadio = new Button((Composite)group, 16);
        this.otaRadio.setText("Over the Air");
        this.otaRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.otaRadio.setLayoutData((Object)gridData);
    }

    private void createJadComponents(Group group) {
        Font font = group.getFont();
        this.jadRadio = new Button((Composite)group, 16);
        this.jadRadio.setText("JAD URL: ");
        this.jadRadio.setSelection(false);
        this.jadRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.jadText = new Text((Composite)group, 2052);
        GridData gridData = new GridData(768);
        this.jadText.setLayoutData((Object)gridData);
        this.jadText.setFont(font);
        this.jadText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.jadBrowseButton = this.createPushButton((Composite)group, "Browse...", null);
        this.jadBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidletTab.this.handleJadBrowseSelected();
            }
        });
    }

    private void createMidletComponents(Group group) {
        Font font = group.getFont();
        this.midletRadio = new Button((Composite)group, 16);
        this.midletRadio.setText(MTJUIStrings.getString("launchtab.midlet.midlet"));
        this.midletRadio.setSelection(true);
        this.midletRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.midletText = new Text((Composite)group, 2052);
        GridData gridData = new GridData(768);
        this.midletText.setLayoutData((Object)gridData);
        this.midletText.setFont(font);
        this.midletText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.searchButton = this.createPushButton((Composite)group, MTJUIStrings.getString("launchtab.midlet.search"), null);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidletTab.this.handleSearchButtonSelected();
            }
        });
    }

    private void createProjectComponents(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        this.projectLabel = new Label(composite2, 0);
        this.projectLabel.setText(MTJUIStrings.getString("launchtab.midlet.project"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.projectLabel.setLayoutData((Object)gridData);
        this.projectLabel.setFont(font);
        this.projectText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.projectText.setLayoutData((Object)gridData);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton(composite2, MTJUIStrings.getString("launchtab.midlet.browse"), null);
        this.projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IJavaProject iJavaProject = MidletTab.this.chooseJavaProject();
                if (iJavaProject != null) {
                    String string = iJavaProject.getElementName();
                    MidletTab.this.projectText.setText(string);
                }
            }
        });
    }

    protected IJavaProject getJavaProject() {
        IJavaProject iJavaProject = null;
        String string = this.projectText.getText().trim();
        if (string.length() > 0) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            iJavaProject = JavaCore.create((IProject)iProject);
        }
        return iJavaProject;
    }

    public String getName() {
        return MTJUIStrings.getString("launchtab.midlet.title");
    }

    private String getStringOrDefault(ILaunchConfiguration iLaunchConfiguration, String string, String string2) {
        String string3 = null;
        try {
            string3 = iLaunchConfiguration.getAttribute(string, string2);
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (Throwable)coreException);
            string3 = string2;
        }
        return string3;
    }

    protected void handleJadBrowseSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{"*.jad"});
        fileDialog.setFilterNames(new String[]{"JAD File"});
        String string = fileDialog.open();
        if (string != null) {
            this.jadText.setText(string);
        }
    }

    protected void handleSearchButtonSelected() {
        try {
            IType iType;
            Object[] objectArray;
            IJavaProject iJavaProject = this.getJavaProject();
            SelectionDialog selectionDialog = MidletSelectionDialogCreator.createMidletSelectionDialog(this.getShell(), (IRunnableContext)this.getLaunchConfigurationDialog(), iJavaProject, false);
            if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()) != null && objectArray.length > 0 && (iType = (IType)objectArray[0]) != null) {
                this.midletText.setText(iType.getFullyQualifiedName());
                iJavaProject = iType.getJavaProject();
                this.projectText.setText(iJavaProject.getElementName());
            }
        }
        catch (JavaModelException javaModelException) {
            MTJCorePlugin.log((int)4, (String)"Choose Midlet", (Throwable)javaModelException);
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.updateProjectFromConfig(iLaunchConfiguration);
        String string = this.getStringOrDefault(iLaunchConfiguration, "mtj.emulated_class", "");
        this.midletText.setText(string);
        String string2 = this.getStringOrDefault(iLaunchConfiguration, "mtj.specified_jad_url", "");
        this.jadText.setText(string2);
        boolean bl = true;
        boolean bl2 = false;
        try {
            bl = iLaunchConfiguration.getAttribute("mtj.do_ota", true);
            bl2 = iLaunchConfiguration.getAttribute("mtj.do_jad_launch", false);
        }
        catch (CoreException coreException) {}
        this.midletRadio.setSelection(!bl && !bl2);
        this.jadRadio.setSelection(bl2);
        this.otaRadio.setSelection(bl && !bl2);
        this.updateEnablement();
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        File file;
        String string = null;
        String string2 = this.projectText.getText().trim();
        if (string2.length() > 0 && !MTJCorePlugin.getWorkspace().getRoot().getProject(string2).exists()) {
            string = MTJUIStrings.getString("launchtab.midlet.error_project_does_not_exist");
        }
        if (string == null && this.midletRadio.getSelection() && (string2 = this.midletText.getText().trim()).length() == 0) {
            string = MTJUIStrings.getString("launchtab.midlet.error_Midlet_not_specified");
        }
        if (string == null && this.jadRadio.getSelection() && !(file = new File(this.jadText.getText())).exists()) {
            string = "Invalid JAD URL specified";
        }
        this.setErrorMessage(string);
        return string == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectText.getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_jad_launch", this.jadRadio.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.specified_jad_url", this.jadText.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", this.otaRadio.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_class", this.midletText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IJavaElement iJavaElement = this.getContext();
        if (iJavaElement != null) {
            this.initializeJavaProject(iJavaElement, iLaunchConfigurationWorkingCopy);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_class", "");
    }

    private void updateEnablement() {
        boolean bl = this.midletRadio.getSelection();
        this.midletText.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        boolean bl2 = this.jadRadio.getSelection();
        this.jadText.setEnabled(bl2);
        this.jadBrowseButton.setEnabled(bl2);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"Error updating project field", (Throwable)coreException);
        }
        this.projectText.setText(string);
    }
}

