/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.project.page;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.internal.wizards.project.NewMIDLetProjectWizard;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewMidletProjectJavaMECapabilityConfigPage
extends JavaCapabilityConfigurationPage {
    public void setVisible(boolean bl) {
        if (bl) {
            this.updateConfiguration();
        }
        super.setVisible(bl);
    }

    public void updateConfiguration() {
        IProject iProject = this.getNewProjectCreatePage().getProjectHandle();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IPath iPath = iProject.getFullPath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        arrayList.add(this.getSrcPathEntry(iPath));
        this.addResourcesDirectoryIfRequested(arrayList, iProject);
        arrayList.add(this.getJavaMEClasspathContainer());
        IClasspathEntry[] iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        this.init(iJavaProject, null, iClasspathEntryArray, false);
    }

    private IClasspathEntry getJavaMEClasspathContainer() {
        return ((NewMIDLetProjectWizard)this.getWizard()).getJavaMEClasspathContainer();
    }

    private void addResourcesDirectoryIfRequested(ArrayList<IClasspathEntry> arrayList, IProject iProject) {
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        if (this.useSourceAndBinaryFolders() && preferences.getBoolean("use_resources_dir")) {
            String string = preferences.getString("resources_dir");
            IFolder iFolder = iProject.getFolder(string);
            arrayList.add(JavaCore.newSourceEntry((IPath)iFolder.getFullPath()));
        }
    }

    private WizardNewProjectCreationPage getNewProjectCreatePage() {
        return (WizardNewProjectCreationPage)this.getWizard().getPage("NewMidletProjectCreationPage");
    }

    private IPath getSrcPath(IPath iPath) {
        IPath iPath2 = iPath;
        if (this.useSourceAndBinaryFolders()) {
            IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
            String string = iPreferenceStore.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
            iPath2 = iPath.append(string);
        }
        return iPath2;
    }

    private IClasspathEntry getSrcPathEntry(IPath iPath) {
        IPath iPath2 = this.getSrcPath(iPath);
        IPath[] iPathArray = null;
        iPathArray = iPath2.equals((Object)iPath) ? new IPath[]{new Path(String.valueOf(MTJCorePlugin.getDeploymentDirectoryName()) + "/"), new Path(".mtj.tmp/")} : new IPath[]{};
        return JavaCore.newSourceEntry((IPath)iPath2, (IPath[])iPathArray);
    }

    private boolean useSourceAndBinaryFolders() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        return iPreferenceStore.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
    }
}

