/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.actions.exporting;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.tools.AntennaBuildExporter;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.internal.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.ui.internal.actions.ConfigurationErrorDialog;
import org.eclipse.mtj.ui.internal.utils.LogAndDisplaySafeRunnable;
import org.eclipse.ui.IWorkbenchPart;

public class AntennaBuildExportAction
extends AbstractJavaProjectAction {
    public void run(IJavaProject iJavaProject, IWorkbenchPart iWorkbenchPart) {
        if (this.configurationIsValid()) {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(iWorkbenchPart.getSite().getShell());
            progressMonitorDialog.open();
            final IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
            iProgressMonitor.beginTask("Export Antenna Build Files", 3);
            IMidletSuiteProject iMidletSuiteProject = this.getMidletSuite(iJavaProject);
            if (iMidletSuiteProject != null) {
                final AntennaBuildExporter antennaBuildExporter = new AntennaBuildExporter(iMidletSuiteProject);
                SafeRunner.run((ISafeRunnable)new LogAndDisplaySafeRunnable(iWorkbenchPart.getSite().getShell(), "export"){

                    public void run() throws Exception {
                        antennaBuildExporter.doExport(iProgressMonitor);
                    }
                });
            }
            iProgressMonitor.done();
            progressMonitorDialog.close();
        } else {
            this.warnUserAboutConfigurationError();
        }
    }

    public void run(IAction iAction) {
        if (this.selection != null && !this.selection.isEmpty()) {
            if (this.configurationIsValid()) {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.workbenchPart.getSite().getShell());
                progressMonitorDialog.open();
                final IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
                iProgressMonitor.beginTask("Export Antenna Build Files", 3);
                Iterator iterator = this.selection.iterator();
                IMidletSuiteProject iMidletSuiteProject = this.getMidletSuite(iterator.next());
                if (iMidletSuiteProject != null) {
                    final AntennaBuildExporter antennaBuildExporter = new AntennaBuildExporter(iMidletSuiteProject);
                    SafeRunner.run((ISafeRunnable)new LogAndDisplaySafeRunnable(this.workbenchPart.getSite().getShell(), "export"){

                        public void run() throws Exception {
                            antennaBuildExporter.doExport(iProgressMonitor);
                        }
                    });
                }
                iProgressMonitor.done();
                progressMonitorDialog.close();
            } else {
                this.warnUserAboutConfigurationError();
            }
        }
    }

    private boolean configurationIsValid() {
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        File file = new File(preferences.getString("antenna_jar"));
        File file2 = new File(preferences.getString("wtk_root"));
        return file.exists() && file.isFile() && file2.exists() && file2.isDirectory();
    }

    private IMidletSuiteProject getMidletSuite(Object object) {
        IMidletSuiteProject iMidletSuiteProject = null;
        IJavaProject iJavaProject = this.getJavaProject(object);
        if (iJavaProject != null) {
            iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        }
        return iMidletSuiteProject;
    }

    private void warnUserAboutConfigurationError() {
        String string = "Antenna preferences are not correctly configured.\nPlease configure Antenna preferences.";
        ConfigurationErrorDialog configurationErrorDialog = new ConfigurationErrorDialog(this.getShell(), "org.eclipse.mtj.ui.preferences.J2MEPreferencePage", "Antenna Export Error", string, "Configure Antenna Preferences...");
        configurationErrorDialog.open();
    }
}

