/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.devices;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.device.preprocess.DeviceSymbolDefinitionSetFactory;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSetRegistry;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.devices.DeviceImportWizardPage;

public class DeviceImportWizard
extends Wizard {
    private DeviceImportWizardPage wizardPage;

    public DeviceImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Import Devices");
        this.setDialogSettings(MTJUIPlugin.getDialogSettings(((Object)((Object)this)).getClass().getName()));
    }

    public void addPages() {
        this.wizardPage = new DeviceImportWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        boolean bl = false;
        IDevice[] iDeviceArray = this.wizardPage.getSelectedDevices();
        boolean bl2 = this.wizardPage.isGenerateDefinitionSet();
        IDevice[] iDeviceArray2 = iDeviceArray;
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray2[n2];
            try {
                DeviceRegistry.singleton.addDevice(iDevice, true);
                if (bl2) {
                    SymbolDefinitionSet symbolDefinitionSet = DeviceSymbolDefinitionSetFactory.createSymbolDefinitionSet((IDevice)iDevice);
                    SymbolDefinitionSetRegistry.singleton.addDefinitionSet(symbolDefinitionSet);
                    SymbolDefinitionSetRegistry.singleton.store();
                }
                bl = true;
            }
            catch (Exception exception) {
                MTJCorePlugin.log((int)2, (String)"Error adding new device", (Throwable)exception);
                MTJUIPlugin.displayError(this.getShell(), 2, -999, "Device Registry Error", "Error adding new device to device registry.", exception);
            }
            ++n2;
        }
        return bl;
    }
}

