/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.LaunchingUtils;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.launching.LauncherMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadLaunchShortcut
implements ILaunchShortcut {
    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> list) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(LauncherMessages.launch_configSelection_title);
        elementListSelectionDialog.setMessage(LauncherMessages.launch_configSelection_message);
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfiguration(IFile iFile) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getEmulatorConfigType();
            String string = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iFile.getName());
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_jad_launch", true);
            String string2 = this.getLaunchingJadFileLocation(iFile);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.specified_jad_url", string2);
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, iFile.getProject().getName());
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"debug", (String)"perspective_default");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"createConfiguration", (Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    private ILaunchConfiguration findLaunchConfiguration(IFile iFile, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        List<ILaunchConfiguration> list = this.getCandidateConfigs(iFile);
        int n = list.size();
        if (n < 1) {
            iLaunchConfiguration = this.createConfiguration(iFile);
        } else if (n == 1) {
            iLaunchConfiguration = list.get(0);
        } else {
            ILaunchConfiguration iLaunchConfiguration2 = this.chooseConfiguration(list);
            if (iLaunchConfiguration2 != null) {
                iLaunchConfiguration = iLaunchConfiguration2;
            }
        }
        return iLaunchConfiguration;
    }

    private List<ILaunchConfiguration> getCandidateConfigs(IFile iFile) {
        ILaunchConfigurationType iLaunchConfigurationType = this.getEmulatorConfigType();
        List<ILaunchConfiguration> list = Collections.emptyList();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            list = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray;
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray2[n2];
                boolean bl = iLaunchConfiguration.getAttribute("mtj.do_jad_launch", false);
                String string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                String string2 = iLaunchConfiguration.getAttribute("mtj.specified_jad_url", "");
                if (bl && string.equals(iFile.getProject().getName()) && string2.indexOf(iFile.getName()) >= 0) {
                    list.add(iLaunchConfiguration);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"getCandidateConfigs", (Throwable)coreException);
        }
        return list;
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return iLaunchConfigurationType;
    }

    private IJavaProject getJavaProject(IFile iFile) {
        IProject iProject = iFile.getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        return iJavaProject;
    }

    private String getLaunchingJadFileLocation(IFile iFile) {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
        IPath iPath = LaunchingUtils.getJadLaunchBasePath((IMidletSuiteProject)iMidletSuiteProject);
        IPath iPath2 = iPath.append(iFile.getName());
        String string = iPath2.toPortableString();
        return string;
    }

    private IMidletSuiteProject getMidletSuiteProject(IFile iFile) {
        IJavaProject iJavaProject = this.getJavaProject(iFile);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        return iMidletSuiteProject;
    }

    private IFile getRuntimeJadFile(IMidletSuiteProject iMidletSuiteProject) {
        IFolder iFolder = LaunchingUtils.getEmulationFolder((IMidletSuiteProject)iMidletSuiteProject);
        IFile iFile = iFolder.getFile(iMidletSuiteProject.getJadFileName());
        return iFile;
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow iWorkbenchWindow = MTJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            shell = iWorkbenchWindow.getShell();
        }
        return shell;
    }

    private boolean isProjectJad(IFile iFile) {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
        String string = iMidletSuiteProject.getJadFileName();
        return string.equals(iFile.getName());
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile != null) {
            this.launch(iFile, string);
        }
    }

    private void launch(IFile iFile, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        if (this.isProjectJad(iFile)) {
            iLaunchConfiguration = this.findLaunchConfiguration(iFile, string);
        } else {
            IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iFile);
            IFile iFile2 = this.getRuntimeJadFile(iMidletSuiteProject);
            iLaunchConfiguration = this.findLaunchConfiguration(iFile2, string);
        }
        if (iLaunchConfiguration == null) {
            return;
        }
        DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
    }

    public void launch(ISelection iSelection, String string) {
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            this.launch(iFile, string);
        } else if (object instanceof IProject) {
            IJavaProject iJavaProject = JavaCore.create((IProject)((IProject)object));
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
            IFile iFile = this.getRuntimeJadFile(iMidletSuiteProject);
            this.launch(iFile, string);
        } else if (object instanceof IJavaProject) {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)((IJavaProject)object));
            IFile iFile = this.getRuntimeJadFile(iMidletSuiteProject);
            this.launch(iFile, string);
        }
    }
}

