/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.ui.internal.launching.DebugTypeSelectionDialog;
import org.eclipse.mtj.ui.internal.launching.LauncherMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaLaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IJavaElement iJavaElement = (IJavaElement)iEditorInput.getAdapter(IJavaElement.class);
        if (iJavaElement != null) {
            this.searchAndLaunch(new Object[]{iJavaElement}, string, this.getTypeSelectionTitle(), this.getEditorEmptyMessage());
        }
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getTypeSelectionTitle(), this.getSelectionEmptyMessage());
        }
    }

    public void searchAndLaunch(Object[] objectArray, String string, String string2, String string3) {
        IType[] iTypeArray = null;
        try {
            iTypeArray = this.findTypes(objectArray, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_0, (String)coreException.getMessage());
            return;
        }
        IType iType = null;
        if (iTypeArray.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_1, (String)string3);
        } else {
            iType = iTypeArray.length > 1 ? this.chooseType(iTypeArray, string2) : iTypeArray[0];
        }
        if (iType != null) {
            this.launch(iType, string);
        }
    }

    private Shell getShell() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray.length > 0) {
                return iWorkbenchWindowArray[0].getShell();
            }
        } else {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> list) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(this.getTypeSelectionTitle());
        elementListSelectionDialog.setMessage(LauncherMessages.JavaLaunchShortcut_2);
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected IType chooseType(IType[] iTypeArray, String string) {
        DebugTypeSelectionDialog debugTypeSelectionDialog = new DebugTypeSelectionDialog(this.getShell(), iTypeArray, string);
        if (debugTypeSelectionDialog.open() == 0) {
            return (IType)debugTypeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(IType var1);

    protected ILaunchConfiguration findLaunchConfiguration(IType iType, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration;
        List<ILaunchConfiguration> list = Collections.emptyList();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            list = new ArrayList(iLaunchConfigurationArray.length);
            ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray;
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                iLaunchConfiguration = iLaunchConfigurationArray2[n2];
                if (iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(iType.getFullyQualifiedName()) && iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(iType.getJavaProject().getElementName())) {
                    list.add(iLaunchConfiguration);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)4, (Throwable)coreException);
        }
        int n = list.size();
        if (n < 1) {
            return this.createConfiguration(iType);
        }
        if (n == 1) {
            return (ILaunchConfiguration)list.get(0);
        }
        iLaunchConfiguration = this.chooseConfiguration(list);
        if (iLaunchConfiguration != null) {
            return iLaunchConfiguration;
        }
        return null;
    }

    protected abstract IType[] findTypes(Object[] var1, IRunnableContext var2) throws InterruptedException, CoreException;

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected abstract String getEditorEmptyMessage();

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected abstract String getSelectionEmptyMessage();

    protected abstract String getTypeSelectionTitle();

    protected void launch(IType iType, String string) {
        ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(iType, this.getConfigurationType());
        if (iLaunchConfiguration != null) {
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
    }

    protected void reportErorr(CoreException coreException) {
        MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)coreException.getStatus().getMessage());
    }
}

