/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletLaunchConfigUtils {
    private static List<IType> collectMidletTypesInProject(IProgressMonitor iProgressMonitor, IJavaProject iJavaProject) {
        HashSet<IType> hashSet = new HashSet<IType>(5);
        try {
            IType iType = iJavaProject.findType("javax.microedition.midlet.MIDlet");
            ITypeHierarchy iTypeHierarchy = iType.newTypeHierarchy(iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IType[] iTypeArray = iTypeHierarchy.getAllSubtypes(iType);
            int n = iTypeArray.length;
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    if (!iTypeArray[n2].isBinary()) {
                        hashSet.add(iTypeArray[n2]);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        iProgressMonitor.done();
        return new ArrayList<IType>(hashSet);
    }

    private static void collectTypes(Object object, SubProgressMonitor subProgressMonitor, Set<IType> set) {
        object = MidletLaunchConfigUtils.computeScope(object);
        try {
            while (object instanceof IMember) {
                if (object instanceof IType && Utils.isMidlet((IType)((IType)object), (IProgressMonitor)subProgressMonitor)) {
                    set.add((IType)object);
                    subProgressMonitor.done();
                    return;
                }
                object = ((IJavaElement)object).getParent();
            }
            if (object instanceof ICompilationUnit) {
                IType[] iTypeArray;
                ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
                IType[] iTypeArray2 = iTypeArray = iCompilationUnit.getAllTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType iType = iTypeArray2[n2];
                    if (Utils.isMidlet((IType)iType, (IProgressMonitor)subProgressMonitor)) {
                        set.add(iType);
                    }
                    ++n2;
                }
            } else if (object instanceof IClassFile) {
                IType iType = ((IClassFile)object).getType();
                if (Utils.isMidlet((IType)iType, (IProgressMonitor)subProgressMonitor)) {
                    set.add(iType);
                }
            } else if (object instanceof IJavaElement) {
                IJavaElement iJavaElement = (IJavaElement)object;
                List<IType> list = MidletLaunchConfigUtils.collectMidletTypesInProject((IProgressMonitor)subProgressMonitor, iJavaElement.getJavaProject());
                Iterator<IType> iterator = list.iterator();
                block4: while (iterator.hasNext()) {
                    IJavaElement iJavaElement2;
                    IJavaElement iJavaElement3 = iJavaElement2 = (IJavaElement)iterator.next();
                    while (iJavaElement3 != null) {
                        if (iJavaElement3.equals(iJavaElement)) {
                            set.add((IType)iJavaElement2);
                            continue block4;
                        }
                        iJavaElement3 = iJavaElement3.getParent();
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            MTJCorePlugin.log((int)2, (String)"collectTypes", (Throwable)javaModelException);
        }
    }

    private static Object computeScope(Object object) {
        if (object instanceof IJavaElement) {
            return object;
        }
        if (object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(IResource.class);
        }
        if (object instanceof IResource) {
            IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)object));
            object = iJavaElement != null && !iJavaElement.exists() ? null : iJavaElement;
        }
        return object;
    }

    public static IType[] findMidlets(IRunnableContext iRunnableContext, final Object[] objectArray) throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress iRunnableWithProgress;
        final HashSet hashSet = new HashSet();
        if (objectArray.length > 0) {
            iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    Object[] objectArray2 = objectArray;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray2[n2];
                        MidletLaunchConfigUtils.collectTypes(object, new SubProgressMonitor(iProgressMonitor, 1), hashSet);
                        ++n2;
                    }
                }
            };
            iRunnableContext.run(true, true, iRunnableWithProgress);
        }
        iRunnableWithProgress = hashSet.toArray(new IType[hashSet.size()]);
        return iRunnableWithProgress;
    }
}

