/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.launching;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.ui.internal.launching.JavaLaunchShortcut;
import org.eclipse.mtj.ui.internal.launching.LauncherMessages;
import org.eclipse.mtj.ui.internal.launching.MidletLaunchConfigUtils;

public class MidletLaunchShortcut
extends JavaLaunchShortcut {
    protected ILaunchConfiguration createConfiguration(IType iType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getConfigurationType();
            String string = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iType.getElementName());
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_class", Utils.getQualifiedClassName((IType)iType));
            iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, iType.getJavaProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationType, (String)"debug", (String)"perspective_default");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            MTJCorePlugin.log((int)2, (String)"createConfiguration", (Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    protected IType[] findTypes(Object[] objectArray, IRunnableContext iRunnableContext) throws InterruptedException, CoreException {
        try {
            return MidletLaunchConfigUtils.findMidlets(iRunnableContext, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (CoreException)invocationTargetException.getTargetException();
        }
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return iLaunchConfigurationType;
    }

    protected String getEditorEmptyMessage() {
        return LauncherMessages.MidletLaunching_EditorContainsNoMidlet;
    }

    protected String getSelectionEmptyMessage() {
        return LauncherMessages.MidletLaunching_SelectionContainsNoMidlet;
    }

    protected String getTypeSelectionTitle() {
        return LauncherMessages.MidletLaunching_SelectionDialogTitle;
    }
}

