/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MultiValuedTableFieldEditor
extends FieldEditor {
    private static final String[] COLUMNS = new String[]{"Value"};
    private static final String[] COLUMN_PROPS = new String[]{"propNames"};
    private Group group;
    private TableViewer tableViewer;
    private StringHolder[] holders;

    public MultiValuedTableFieldEditor(String string, String string2, Composite composite) {
        super(string, string2, composite);
    }

    public int getNumberOfControls() {
        return 1;
    }

    private void addNewPropertyName() {
        StringHolder[] stringHolderArray = new StringHolder[this.holders.length + 1];
        System.arraycopy(this.holders, 0, stringHolderArray, 0, this.holders.length);
        stringHolderArray[this.holders.length] = new StringHolder("New Value");
        this.setExcludedNames(stringHolderArray);
    }

    private String getMultiValuedString(StringHolder[] stringHolderArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringHolderArray.length) {
            StringHolder stringHolder = stringHolderArray[n];
            if (n != 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(stringHolder.value);
            ++n;
        }
        return stringBuffer.toString();
    }

    private StringHolder[] getParsedValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        StringHolder[] stringHolderArray = new StringHolder[n];
        int n2 = 0;
        while (n2 < n) {
            stringHolderArray[n2] = new StringHolder(stringTokenizer.nextToken());
            ++n2;
        }
        return stringHolderArray;
    }

    private void removeSelectedNames() {
        int[] nArray = this.tableViewer.getTable().getSelectionIndices();
        ArrayList arrayList = new ArrayList(Arrays.asList(this.holders));
        int n = nArray.length;
        while (n > 0) {
            int n2 = nArray[n - 1];
            arrayList.remove(n2);
            --n;
        }
        this.setExcludedNames(arrayList.toArray(new StringHolder[arrayList.size()]));
    }

    private void setExcludedNames(StringHolder[] stringHolderArray) {
        this.holders = stringHolderArray;
        this.tableViewer.setInput((Object)this.holders);
        this.tableViewer.refresh();
    }

    protected void adjustForNumColumns(int n) {
        ((GridData)this.group.getLayoutData()).horizontalSpan = n;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = n;
        this.group = new Group(composite, 0);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)gridData);
        this.group.setText(this.getLabelText());
        this.tableViewer = new TableViewer((Composite)this.group, 68356);
        this.tableViewer.setColumnProperties(COLUMN_PROPS);
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        final Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite((Composite)this.group, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button(composite2, 8);
        button.setText("Add");
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MultiValuedTableFieldEditor.this.addNewPropertyName();
            }
        });
        new Label(composite2, 0);
        final Button button2 = new Button(composite2, 8);
        button2.setText("Remove");
        button2.setLayoutData((Object)new GridData(768));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MultiValuedTableFieldEditor.this.removeSelectedNames();
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                button2.setEnabled(tableItem.getParent().getSelectionCount() > 0);
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        this.tableViewer.setCellEditors(cellEditorArray);
        final TableColumn[] tableColumnArray = new TableColumn[COLUMNS.length];
        int n2 = 0;
        while (n2 < COLUMNS.length) {
            tableColumnArray[n2] = new TableColumn(table, 0);
            tableColumnArray[n2].setText(COLUMNS[n2]);
            ++n2;
        }
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                tableColumnArray[0].setWidth(table.getSize().x);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    protected void doLoad() {
        if (this.group != null) {
            String string = this.getPreferenceStore().getString(this.getPreferenceName());
            this.setExcludedNames(this.getParsedValues(string));
        }
    }

    protected void doLoadDefault() {
        if (this.group != null) {
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.setExcludedNames(this.getParsedValues(string));
        }
    }

    protected void doStore() {
        String string = this.getMultiValuedString(this.holders);
        this.getPreferenceStore().setValue(this.getPreferenceName(), string);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return string != null && string.equals(COLUMN_PROPS[0]);
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (this.canModify(object, string)) {
                string2 = object.toString();
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = (String)object2;
                if (object3 instanceof StringHolder) {
                    ((StringHolder)object3).value = string2;
                    MultiValuedTableFieldEditor.this.tableViewer.update(object3, new String[]{string});
                }
            }
        }
    }

    private static class StringHolder {
        public String value;

        public StringHolder(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return MultiValuedTableFieldEditor.this.holders;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return n == 0 ? object.toString() : "";
        }
    }
}

