/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.importer.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ArchiveFileManipulations;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ArchiveUtils;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectImporter;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ProjectRecord;
import org.eclipse.mtj.ui.internal.wizards.importer.common.TarException;
import org.eclipse.mtj.ui.internal.wizards.importer.common.TarFile;
import org.eclipse.mtj.ui.internal.wizards.importer.common.TarLeveledStructureProvider;
import org.eclipse.mtj.ui.internal.wizards.importer.common.ZipLeveledStructureProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportProjectWizardPage
extends WizardPage
implements IOverwriteQuery {
    private static final String STORE_ARCHIVE_SELECTED = "ProjectImportWizard.STORE_ARCHIVE_SELECTED";
    private Text directoryPathField;
    private CheckboxTreeViewer projectsList;
    private ProjectRecord[] foundProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Text archivePathField;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private IProject[] wsProjects;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String lastPath;
    private long lastModified;
    private ProjectImporter importer;
    private ILeveledImportStructureProvider structureProvider;
    private String productName;

    public ImportProjectWizardPage(ProjectImporter projectImporter, String string) {
        this("wizardExternalProjectsPage", projectImporter, string);
    }

    public ImportProjectWizardPage(String string, ProjectImporter projectImporter, String string2) {
        super(string);
        this.importer = projectImporter;
        this.productName = string2;
        this.setPageComplete(false);
        this.setTitle(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsTitle, (Object)string2));
        this.setDescription(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription, (Object)string2));
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(composite2);
        this.createProjectsList(composite2);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite2);
    }

    private void createProjectsList(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(ProjectImporterMessage.WizardProjectsImportPage_ProjectsListTitle);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(composite2, 2048);
        GridData gridData = new GridData(1808);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object object) {
                return null;
            }

            public Object[] getElements(Object object) {
                return ImportProjectWizardPage.this.getFoundProjects();
            }

            public boolean hasChildren(Object object) {
                return false;
            }

            public Object getParent(Object object) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((ProjectRecord)object).getProjectLabel();
            }
        });
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ImportProjectWizardPage.this.checkPageComplete();
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(composite2);
    }

    private void checkPageComplete() {
        Object[] objectArray = this.projectsList.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ProjectRecord projectRecord = (ProjectRecord)object;
            if (this.isProjectInWorkspace(projectRecord.getProjectName())) {
                this.setMessage(NLS.bind((String)ProjectImporterMessage.ImportProjectWizardPage_ProjectAlreadyInWorkpace, (Object)projectRecord.getProjectName()), 3);
                this.setPageComplete(false);
                return;
            }
            ++n2;
        }
        this.setMessage(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_ImportProjectsDescription, (Object)this.productName));
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
    }

    private void createSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(2));
        Button button = new Button(composite2, 8);
        button.setText(ProjectImporterMessage.DataTransfer_selectAll);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.projectsList.setCheckedElements((Object[])ImportProjectWizardPage.this.foundProjects);
                ImportProjectWizardPage.this.checkPageComplete();
            }
        });
        Dialog.applyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite2, 8);
        button2.setText(ProjectImporterMessage.DataTransfer_deselectAll);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                ImportProjectWizardPage.this.checkPageComplete();
            }
        });
        Dialog.applyDialogFont((Control)button2);
        this.setButtonLayoutData(button2);
        Button button3 = new Button(composite2, 8);
        button3.setText(ProjectImporterMessage.DataTransfer_refresh);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImportProjectWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
                } else {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        Dialog.applyDialogFont((Control)button3);
        this.setButtonLayoutData(button3);
    }

    private void createProjectsRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(composite2, 16);
        this.projectFromDirectoryRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Text(composite2, 2048);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(composite2, 8);
        this.browseDirectoriesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(composite2, 16);
        this.projectFromArchiveRadio.setText(ProjectImporterMessage.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Text(composite2, 2048);
        this.archivePathField.setLayoutData((Object)new GridData(768));
        this.browseArchivesButton = new Button(composite2, 8);
        this.browseArchivesButton.setText(ProjectImporterMessage.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4) {
                    traverseEvent.doit = false;
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
                }
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.archiveRadioSelected();
            }
        });
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (bl && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(final String string) {
        if (string == null || string.length() == 0) {
            this.foundProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.foundProjects);
            this.checkPageComplete();
            this.lastPath = string;
            return;
        }
        final File file = new File(string);
        long l = file.lastModified();
        if (string.equals(this.lastPath) && this.lastModified == l) {
            return;
        }
        this.lastPath = string;
        this.lastModified = l;
        final boolean bl = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    iProgressMonitor.beginTask(ProjectImporterMessage.WizardProjectsImportPage_SearchingMessage, 100);
                    ImportProjectWizardPage.this.foundProjects = new ProjectRecord[0];
                    if (!bl) {
                        if (ArchiveFileManipulations.isTarFile(string)) {
                            TarFile tarFile = ImportProjectWizardPage.this.getSpecifiedTarSourceFile(string);
                            if (tarFile == null) {
                                return;
                            }
                            ImportProjectWizardPage.this.structureProvider = new TarLeveledStructureProvider(tarFile);
                        } else if (ArchiveFileManipulations.isZipFile(string)) {
                            ZipFile zipFile = ImportProjectWizardPage.this.getSpecifiedZipSourceFile(string);
                            if (zipFile == null) {
                                return;
                            }
                            ImportProjectWizardPage.this.structureProvider = new ZipLeveledStructureProvider(zipFile);
                        }
                        ImportProjectWizardPage.this.foundProjects = ImportProjectWizardPage.this.importer.searchProjectsFromProvider(ImportProjectWizardPage.this.structureProvider, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100).newChild(100));
                    } else if (bl && file.isDirectory()) {
                        ImportProjectWizardPage.this.foundProjects = ImportProjectWizardPage.this.importer.searchProjectsFromDirectory(file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100).newChild(100));
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJCorePlugin.log((int)4, (String)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.setCheckedElements((Object[])this.foundProjects);
        this.checkPageComplete();
    }

    private ZipFile getSpecifiedZipSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(string);
        }
        catch (ZipException zipException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new TarFile(string);
        }
        catch (TarException tarException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorMessageDialog(ProjectImporterMessage.WizardImportPage_internalErrorTitle, ProjectImporterMessage.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    protected void handleLocationDirectoryButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.directoryPathField.getShell());
        directoryDialog.setMessage(ProjectImporterMessage.WizardProjectsImportPage_SelectDialogTitle);
        String string = this.directoryPathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedDirectory;
        }
        if (string.length() == 0) {
            directoryDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string);
            if (((File)object).exists()) {
                directoryDialog.setFilterPath(new Path(string).toOSString());
            }
        }
        object = directoryDialog.open();
        if (object != null) {
            previouslyBrowsedDirectory = object;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList((String)object);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.archivePathField.getShell());
        fileDialog.setFilterExtensions(FILE_IMPORT_MASK);
        fileDialog.setText(ProjectImporterMessage.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String string = this.archivePathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedArchive;
        }
        if (string.length() == 0) {
            fileDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string).getParentFile();
            if (object != null && ((File)object).exists()) {
                fileDialog.setFilterPath(((File)object).toString());
            }
        }
        object = fileDialog.open();
        if (object != null) {
            previouslyBrowsedArchive = object;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList((String)object);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] objectArray = this.projectsList.getCheckedElements();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iProgressMonitor.beginTask("", objectArray.length);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int n = 0;
                    while (n < objectArray.length) {
                        ImportProjectWizardPage.this.createExistingProject((ProjectRecord)objectArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        ++n;
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = ProjectImporterMessage.WizardExternalProjectImportPage_errorMessage;
            Object object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.mtj.ui", 1, string, throwable);
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)object);
            return false;
        }
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        return true;
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
    }

    private boolean createExistingProject(ProjectRecord projectRecord, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        String string = projectRecord.getProjectName();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(string);
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(string);
        try {
            ImportOperation importOperation;
            List list;
            Object object;
            Object object2;
            iProgressMonitor.beginTask(NLS.bind((String)ProjectImporterMessage.WizardProjectsImportPage_CreateProjectTask, (Object)projectRecord.getProjectName()), 100);
            JavaCapabilityConfigurationPage.createProject((IProject)iProject, (URI)iProjectDescription.getLocationURI(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20));
            if (projectRecord.getProvider() == null) {
                object2 = new Path(new File(projectRecord.getProjectRoot()).getAbsolutePath());
                object = object2.toFile();
                if (!Platform.getLocation().isPrefixOf((IPath)object2)) {
                    list = FileSystemStructureProvider.INSTANCE.getChildren(object);
                    importOperation = new ImportOperation(iProject.getFullPath(), object, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, list);
                    importOperation.setContext(this.getShell());
                    importOperation.setOverwriteResources(true);
                    importOperation.setCreateContainerStructure(false);
                    importOperation.run((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20));
                    iProgressMonitor.worked(50);
                    this.importer.projectCreated(projectRecord, iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20));
                }
            } else {
                object2 = ArchiveUtils.getChild(projectRecord.getProvider(), projectRecord.getProvider().getRoot(), projectRecord.getProjectRoot());
                object = projectRecord.getProvider().getChildren(object2);
                int n = ArchiveUtils.guessStripLevel(projectRecord.getProjectRoot());
                projectRecord.getProvider().setStrip(n);
                importOperation = new ImportOperation(iProject.getFullPath(), projectRecord.getProvider().getRoot(), (IImportStructureProvider)projectRecord.getProvider(), (IOverwriteQuery)this, (List)object);
                importOperation.setContext(this.getShell());
                importOperation.run(iProgressMonitor);
                this.importer.projectCreated(projectRecord, iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 20));
            }
            iProgressMonitor.setTaskName(ProjectImporterMessage.WizardProjectsImportPage_ProcessingMessage);
            iProject.refreshLocal(2, null);
            object2 = new ClassPathDetector(iProject, null);
            object = new JavaCapabilityConfigurationPage();
            object.init(JavaCore.create((IProject)iProject), object2.getOutputLocation(), object2.getClasspath(), false);
            object.configureJavaProject(null);
            this.removeJ2SELibraries(object.getJavaProject(), iProgressMonitor);
            list = this.importer.getProjectDevice(projectRecord);
            importOperation = MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)iProject, (IJavaProject)object.getJavaProject(), (IDevice)list, (String)MidletSuiteProject.getDefaultJadFileName((IProject)iProject));
            importOperation.run(iProgressMonitor);
            iProject.build(6, iProgressMonitor);
            iProgressMonitor.done();
        }
        catch (CoreException coreException) {
            try {
                iProject.delete(true, iProgressMonitor);
            }
            catch (CoreException coreException2) {}
            throw new InvocationTargetException(coreException);
        }
        return true;
    }

    private void removeJ2SELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (!this.isJ2SELibraryEntry(iClasspathEntryArray[n])) {
                arrayList.add(iClasspathEntryArray[n]);
            }
            ++n;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
    }

    private boolean isJ2SELibraryEntry(IClasspathEntry iClasspathEntry) {
        boolean bl = false;
        if (iClasspathEntry.getEntryKind() == 1) {
            if (iClasspathEntry.getPath().lastSegment().equals("JRE_LIB")) {
                bl = true;
            }
        } else if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            bl = true;
        }
        return bl;
    }

    public String queryOverwrite(String string) {
        Path path = new Path(string);
        String string2 = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_existsQuestion, (Object)string) : NLS.bind((String)ProjectImporterMessage.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog messageDialog = new MessageDialog(this.getContainer().getShell(), ProjectImporterMessage.Question, null, string2, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] stringArray = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                messageDialog.open();
            }
        });
        return messageDialog.getReturnCode() < 0 ? "CANCEL" : stringArray[messageDialog.getReturnCode()];
    }

    private void displayErrorMessageDialog(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)ImportProjectWizardPage.this.getShell(), (String)string, (String)string2);
            }
        };
        this.getShell().getDisplay().syncExec(runnable);
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getFoundProjects() {
        return this.foundProjects;
    }

    private boolean isProjectInWorkspace(String string) {
        if (string == null) {
            return false;
        }
        IProject[] iProjectArray = this.getProjectsInWorkspace();
        int n = 0;
        while (n < iProjectArray.length) {
            if (string.equals(iProjectArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            boolean bl = iDialogSettings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!bl);
            this.projectFromArchiveRadio.setSelection(bl);
            if (bl) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }
}

