/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.project.page;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.ui.devices.DeviceSelector;
import org.eclipse.mtj.ui.internal.wizards.project.NewMIDLetProjectWizard;
import org.eclipse.mtj.ui.internal.wizards.project.NewMidletProjectWizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewMidletProjectPropertiesPage
extends WizardPage {
    public static final String PAGE_NAME = "NewMidletProjectProperties";
    private DeviceSelector deviceSelector;
    private Text jadFileNameText;
    private boolean jadNameInitialized;
    private int deviceCount = 0;

    public NewMidletProjectPropertiesPage() {
        super(PAGE_NAME);
        this.setTitle(NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_title);
        this.setDescription(NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_description);
        this.deviceCount = this.getDeviceCount();
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(font);
        this.setControl((Control)composite2);
        this.initializeDialogUnits((Control)composite);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents(composite2, true, true);
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NewMidletProjectPropertiesPage.this.updateStatus();
            }
        });
        Group group = new Group(composite2, 4);
        group.setText(NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_jad_groupname);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0).setText(NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_jad_label);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        this.jadFileNameText = new Text((Composite)group, 2048);
        this.jadFileNameText.setLayoutData((Object)new GridData(768));
        this.jadFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewMidletProjectPropertiesPage.this.updateStatus();
            }
        });
        new Label((Composite)group, 0);
        this.updateStatus();
    }

    public void dispose() {
        this.deviceSelector.dispose();
        super.dispose();
    }

    public String getJadFileName() {
        return this.jadFileNameText.getText();
    }

    public IDevice getSelectedDevice() {
        return this.deviceSelector.getSelectedDevice();
    }

    public boolean isPageComplete() {
        return this.isValidDeviceCount().isOK() && this.isValidDeviceSelection().isOK() && this.isValidJadName().isOK();
    }

    public void setVisible(boolean bl) {
        if (bl && !this.jadNameInitialized) {
            this.jadFileNameText.setText(this.getDefaultJadName());
            this.jadNameInitialized = true;
        }
        super.setVisible(bl);
    }

    private String getDefaultJadName() {
        IProject iProject = ((NewMIDLetProjectWizard)this.getWizard()).getCreatedProjectHandle();
        return MidletSuiteProject.getDefaultJadFileName((IProject)iProject);
    }

    private int getDeviceCount() {
        int n = 0;
        DeviceRegistry deviceRegistry = DeviceRegistry.singleton;
        try {
            n = deviceRegistry.getDeviceCount();
        }
        catch (PersistenceException persistenceException) {
            MTJCorePlugin.log((int)2, (String)"Error retrieving device count", (Throwable)persistenceException);
        }
        return n;
    }

    private IStatus isValidDeviceCount() {
        Status status = null;
        status = this.deviceCount <= 0 ? new Status(4, "org.eclipse.mtj.ui", NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_validate_devicecount_error) : new Status(0, "org.eclipse.mtj.ui", "");
        return status;
    }

    private IStatus isValidDeviceSelection() {
        Status status = null;
        status = this.getSelectedDevice() == null ? new Status(4, "org.eclipse.mtj.ui", NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_validate_devicecount_error) : new Status(0, "org.eclipse.mtj.ui", "");
        return status;
    }

    private IStatus isValidJadName() {
        String string = this.getJadFileName();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Status status = new Status(4, "org.eclipse.mtj.ui", NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_validate_jadname_error_invalidname);
        if (string != null && (status = iWorkspace.validateName(string, 1)).isOK()) {
            if (!string.endsWith(".jad")) {
                status = new Status(4, "org.eclipse.mtj.ui", NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_validate_jadname_error_extension);
            } else if (string.equals(".jad")) {
                status = new Status(4, "org.eclipse.mtj.ui", NewMidletProjectWizardMessages.NewMidletProjectPropertiesPage_validate_jadname_error_emptyname);
            }
        }
        return status;
    }

    private void updateStatus() {
        this.deviceCount = this.getDeviceCount();
        IStatus iStatus = this.isValidDeviceCount();
        if (iStatus.isOK() && (iStatus = this.isValidDeviceSelection()).isOK()) {
            iStatus = this.isValidJadName();
        }
        if (iStatus.isOK()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            ((NewMIDLetProjectWizard)this.getWizard()).setProjectDevice(this.getSelectedDevice());
        } else {
            this.setErrorMessage(iStatus.getMessage());
            this.setPageComplete(false);
        }
    }
}

