/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.creole.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class NowikiBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("^\\{\\{\\{\\s*$");
    private static final Pattern endPattern = Pattern.compile("^\\}\\}\\}\\s*$");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        } else {
            Matcher endMatcher = endPattern.matcher(line);
            if (endMatcher.matches()) {
                this.setClosed(true);
                return -1;
            }
            this.builder.characters(line);
            this.builder.characters("\n");
        }
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

